proc(nada)=ndw(v)
; -----------------------------------------------------------------
; Library        metrics
; -----------------------------------------------------------------
;  See_also      adedis simpsonint
; -----------------------------------------------------------------
;   Macro        ndw 
; -----------------------------------------------------------------
;   Keywords     numerical integration, semiparametric estimation,
;		 average derivative
; -----------------------------------------------------------------
;   Description  ndw is an auxiliary macro of adedis. It defines 
;                the nadaraya watson estimate of the link as a function
;                of the (estimated) index of continuous explanatory
;                variables. In adedis the simpsonint routine is used to
;                integrate over this function.
; -----------------------------------------------------------------
;   Reference    Horowitz and Haerdle (1996), "Direct Semiparametric Estimation 
;                of a Single-Index Model with Discrete Covariates," 
;                Journal of the American Statistical Association, 91, 1632-1640
; -----------------------------------------------------------------
;   Usage        nada=ndw(v)     
;   Input
;     Parameter   v  
;     Definition      n x 1 matrix , domain of NDW; the estimated index of the continuous explanatory variables V=x'b      
;   Output                      
;     Parameter   nada 
;     Definition      n x 1 matrix. range of NDW; the estimated link G(x'b)     
; -----------------------------------------------------------------
;   Author    Charles de Garchy, 970302  
; -----------------------------------------------------------------
xb=getglobal("xxb")
yb=getglobal("yyb")
hx=getglobal("hx")
c0=getglobal("c0")
c1=getglobal("c1")
u=(xb-v)./hx
dx=(105/64)*(1-5*u^2+7*u^4-3*u^6).*(abs(u).<=1)
dxy=dx.*yb
nada=sum(dxy)./(sum(dx)+1e-10)
nada=c0.*(nada .< c0) + nada.*(c0 .<= nada).*(nada .<= c1)+ c1.*(c1 .< nada)
nada=nada/(c1 - c0)
endp
