proc(d)=normalt(t,di,ord,covu,u,outp);
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      portmant
; -----------------------------------------------------------------
;   Macro         normalt
; -----------------------------------------------------------------
;   Description   multivariate normality tests
; -----------------------------------------------------------------
;   Usage         d = normalt(t,di,ord,covu,u)
;   Input
;     Parameter   t 
;     Definition    matrix, t-values
;     Parameter   di
;     Definition    integer, dimension
;     Parameter   ord 
;     Definition    integer, order of the series 
;     Parameter   covu
;     Definition    matrix, covariances
;     Parameter   u 
;     Definition    matrix 
;   Output
;     Parameter   d
;     Definition    text display
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971027
; -----------------------------------------------------------------
  p=chol(covu)';
  w=inv(p)*u;
  b=sum((w.^3)')'./t;
  c=sum((w.^4)')'./t;
  drei=ones(di,1)*3;
  skew=t*b'*b/6;
  kurt=t*(c-drei)'*(c-drei)/24;
  skewkurt=skew+kurt;
  lambda=skew|kurt|skewkurt;
  df=di|di|2*di;
  chi=cdfc(lambda,df);
  d=createdisplay(2,1)
  str="                          x     df   Chi2(df,x) " | " "
  str=str| "Skewness:              " + string(" %5.2f ", skew) + string(" %3.0f ", df[1])  + string("   %5.2f ", chi[1])
  str=str|" "|"Kurtosis:              " + string(" %5.2f ", kurt) + string(" %3.0f ", df[2])  + string("   %5.2f ", chi[2])
  str=str|" "|"Skewness and Kurtosis: " + string(" %5.2f ", skewkurt) + string(" %3.0f ", df[3])  + string("   %5.2f ", chi[3])
  show(d,1,1,str)
  if (outp==1)
     str
  endif
  str="  x: Value of Statistic"
  str=str|" "|"  df: degrees of freedom"
  str=str|" "|"  Chi2(df,x): Chi-square cdf"
  str=str|" "|"  Reject normality e.g. if Chi2(df,x) > 0.95 !"
  show(d,2,1,str)
  if (outp==1)
     str
  endif
endp;
