proc(err)=check(str, left, right)
  res = (left.=right)
  err = sum(sum(res,2))<>prod(dim(res))
  if (err)
    string ("%-10s ... failed", str)
    res
  else
    string ("%-10s ... OK", str)
  endif
endp
proc(val)=constant(fix, func, eps)
  if (abs(fix-func)<eps)
    val = func
  else
    val = fix
  endif
endp
proc(err)=numcomp()
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    
; ---------------------------------------------------------------------
; Macro       numcomp
; ---------------------------------------------------------------------
; Description numcomp.xpl tests some mathematical functions whether 
;             they give the right result for the matrix
;             x=#(-Inf, 0, 1, Inf, -NaN, NaN)
; ---------------------------------------------------------------------
; Usage       err=numcomp()
; Input       
; Output      
; Parameter   err
; Definition  
; ---------------------------------------------------------------------
; Notes       Depending on your machine (i.e. Intel or Sun) and your
;             operating system (i.e. Windows, Sun Solaris, Linux),
;             it may happen that some compiler built-in
;             mathematical functions did not work properly, especially for
;             x=#(NaN, -Inf).
;             If you still find further errors then please contact 
;             MD*Tech at mdtech@mdtech.de    
; ---------------------------------------------------------------------
; Author      Sigbert Klinke, 000717
; ---------------------------------------------------------------------
  err = 0
  eps    = 1.0e-12
  pi2    = constant(1.570796326794896557998981734272092580795288086, asin(1), eps)
  pi4    = constant(0.785398163397448278999490867136046290397644043, atan(1), eps)
  asinh1 = constant(0.881373587019543047738068253238452598452568054, asinh(1), eps)
  cos1   = constant(0.540302305868139765010482733487151563167572021, cos(1), eps)
  cosh1  = constant(1.543080634815243934454542795720044523477554321, cosh(1), eps)
  sin1   = constant(0.841470984807896504875657228694763034582138062, sin(1), eps)
  tan1   = constant(1.557407724654902292371616567834280431270599365, tan(1), eps)
  tanh1  = constant(0.761594155955764851029243800439871847629547119, tanh(1), eps)
  e      = constant(2.718281828459045534884808148490265011787414551, exp(1), eps)
  e1     = constant(1.718281828459045090795598298427648842334747314, expm1(1), eps)
  log2   = constant(0.693147180559945286226763982995180413126945496, log1p(1), eps)
  x=#(-Inf, 0, 1, Inf, -NaN, NaN)
; check .+
  res=#(-Inf, -Inf, -Inf, NaN, -NaN, NaN)
  res=res~#(-Inf, 0, 1, Inf, -NaN, NaN)
  res=res~#(-Inf, 1, 2, Inf, -NaN, NaN)
  res=res~#(NaN, Inf, Inf, Inf, -NaN, NaN)
  res=res~#(-NaN, -NaN, -NaN, -NaN, -NaN, -NaN)
  res=res~#(NaN, NaN, NaN, NaN, NaN, NaN)
  err=err+check(".+", x.+x', res)
; check .-
  res=#(NaN, Inf, Inf, Inf, -NaN, NaN)
  res=res~#(-Inf, 0, 1, Inf, -NaN, NaN)
  res=res~#(-Inf, -1, 0, Inf, -NaN, NaN)
  res=res~#(-Inf, -Inf, -Inf, NaN, -NaN, NaN)
  res=res~#(-NaN, -NaN, -NaN, -NaN, -NaN, -NaN)
  res=res~#(NaN, NaN, NaN, NaN, NaN, NaN)
  err=err+check(".-", x.-x', res)
; check .*
  res=#(Inf, NaN, -Inf, -Inf, -NaN, NaN)
  res=res~#(NaN, 0, 0, NaN, -NaN, NaN)
  res=res~#(-Inf, 0, 1, Inf, -NaN, NaN)
  res=res~#(-Inf, NaN, Inf, Inf, -NaN, NaN)
  res=res~#(-NaN, -NaN, -NaN, -NaN, -NaN, -NaN)
  res=res~#(NaN, NaN, NaN, NaN, NaN, NaN)
  err=err+check(".*", x.*x', res)
; check ./
  res=#(NaN, -0, -0, NaN, -NaN, NaN)
  res=res~#(-Inf, NaN, Inf, Inf, -NaN, NaN)
  res=res~#(-Inf, 0, 1, Inf, -NaN, NaN)
  res=res~#(NaN, 0, 0, NaN, -NaN, NaN)
  res=res~#(-NaN, -NaN, -NaN, -NaN, -NaN, -NaN)
  res=res~#(NaN, NaN, NaN, NaN, NaN, NaN)
  err=err+check("./", x./x', res)
; abs
  res=#(Inf, 0, 1, Inf, NaN, NaN)
  err=err+check("abs", abs(x), res)
;ceil(x)
  res=#(-Inf, 0, 1, Inf, -NaN, NaN)
  err=err+check("ceil", ceil(x), res)
;floor(x)
  res=#(-Inf, 0, 1, Inf, -NaN, NaN)
  err=err+check("floor", floor(x), res)
;rint(x) 
  res=#(-Inf, 0, 1, Inf, -NaN, NaN)
  err=err+check("rint", rint(x), res)
;sqrt(x)
  res=#(NaN, 0, 1, Inf, -NaN, NaN)  // #(-nan,...) ????
  err=err+check ("sqrt", sqrt(x), res)
;acos(x)
  res=#(NaN, pi/2, 0, NaN, -NaN, NaN)
  err=err+check ("acos", acos(x), res)
;acosh(x)
  res=#(NaN, NaN, 0, Inf, -NaN, NaN)  // #(-nan,...) ????
  err=err+check ("acosh", acosh(x), res)
;asin(x)
  // res=#(0, 0, pi2, 0, -NaN, NaN)  //--> #(-NaN, 0, pi2, NaN, -NaN, +NaN)
  res=#(-NaN, 0, pi2, NaN, -NaN, +NaN)
  err=err+check ("asin", asin(x), res)
;asinh(x)  // falsches erg unter win fuer -inf
  res=#(-Inf, 0, asinh1, Inf, -NaN, NaN)
  err=err+check ("asinh", asinh(x), res)
;atan(x)
  res=#(-pi2, 0, pi4, pi2, -NaN, NaN)
  err=err+check ("atan", atan(x), res)
;atanh(x)
  res=#(NaN, 0, Inf, NaN, -NaN, NaN) // #(-nan,...)???
  err=err+check ("atanh", atanh(x), res)
;cos(x)
  res=#(NaN, 1, cos1, NaN, -NaN, NaN)
  err=err+check ("cos", cos(x), res)
;cosh(x)
  res=#(Inf, 1, cosh1, Inf, -NaN, NaN)
  err=err+check ("cosh", cosh(x), res)
;sin(x)
  res=#(NaN, 0, sin1, NaN, -NaN, NaN) //+-NaN?????
  err=err+check ("sin", sin(x), res)
;tan(x)
  res=#(NaN,0, tan1, NaN, -NaN, NaN)
  err=err+check ("tan", tan(x), res)
;tanh(x) 
  res=#(-1, 0, tanh1, 1, -NaN, NaN)
  err=err+check ("tanh", tanh(x), res)
;exp(x)
  res=#(0, 1, e, Inf, -NaN, NaN)
  err=err+check ("exp", exp(x), res)
;expm1(x)  // hier: rundung!! sonst ok
// res=#(0, 0.36787944117, 1, +Inf, -NaN, NaN)
   res=#(-1, 0, e1, Inf, -NaN, NaN)
  err=err+check ("expm1", expm1(x), res)
;lgamma(x)
  res=#(NaN, NaN, 0, Inf, -NaN, NaN)
  err=err+check ("lgamma", lgamma(x), res)
;log(x)
res=#(-NaN, -Inf, 0, Inf, -NaN, NaN)  //!!
// ???  res=#(-Inf, -Inf, 0, Inf, -NaN, NaN)
  err=err+check ("log", log(x), res)
;log10(x)
// ????????  res=#(-Inf, -Inf, 0, Inf, -NaN, NaN)
res=#(-NaN, -Inf, 0, Inf, -NaN, NaN)
  err=err+check ("log10", log10(x), res)
;log1p(x)
  res=#(NaN, 0, log2, Inf, -NaN, NaN)
  err=err+check ("log1p", log1p(x), res)  
endp
