proc(omega)=omerrgen(coeff,phi,sigma,h,t,ord,di,tb,te,adj,typ,ytt)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  domulti, modelrr
; ----------------------------------------------------------------------
;   Macro	  omerrgen
; ----------------------------------------------------------------------
;   Description   Generation of Omega for the reduced rank VAR model 
; ----------------------------------------------------------------------
;   Usage         omega=omerrgen(coeff,phi,sigma,h,t,ord,di,tb,te,adj,typ,ytt)
;   Input 
;     Parameter   coeff 
;     Definition     matrix, the coefficients 
;     Parameter   phi 
;     Definition     matrix, 
;     Parameter   sigma 
;     Definition     vector, standard error
;     Parameter   h 
;     Definition     integer, forecast horizon
;     Parameter   t 
;     Definition     integer
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   tb 
;     Definition     integer, (time) begin
;     Parameter   te 
;     Definition     integer, (time) end 
;     Parameter   adj 
;     Definition    scalar, 1=if adjusted, 0=if not
;     Parameter   typ 
;     Definition     integer, describing the model type
;     Parameter   ytt 
;     Definition     matrix, the time series
;   Output
;     Parameter   omega
;     Definition     matrix, 
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich 971204, CH 980408
; ---------------------------------------------------------------------- 
if (coeff==0)
   omega=0
else
   k1=cols(coeff)
   k2=cols(phi)
   i1=1
   omega=zeros(1,k2)
   yy=ytt-adj*mean(ytt[,tb:te]')'
   z=zxgen(yy,tb-1,te-1,ord,adj)
   while (i1<=h)
      var1=0
      i2=1
      while (i2<=t)
         i3=0
         var2=0
         while (i3<=i1-1)
            var2=var2+kron(z[,i2]'*power(coeff',i1-1-i3), phi[i3*k2+1:(i3+1)*k2,])
            i3=i3+1
         endo
        var1=var1+var2*sigma*var2'
        i2=i2+1
     endo
     omega=omega|var1
     i1=i1+1
  endo
  omega=omega[2:rows(omega),]/t
endif
endp
