proc(output)=outputanova(dfR,dfM,dfT,MSSRin,MSSMin,MSSTin)
; -----------------------------------------------------------------------
; Library  stats     
; -----------------------------------------------------------------------
; See_also outputbs outputfs2 outputpar outputstep    
; -----------------------------------------------------------------------
; Macro        outputanova
; -----------------------------------------------------------------------
; Description creates a anova table for linregbs, linregfs, linregstep  
; -----------------------------------------------------------------------
; Notes to be used only in context with linear regression macros  or 
;       in context with "doista"       
; -----------------------------------------------------------------------
//ANOVA table	
	SSMin=MSSMin*dfM
        dfMstr=string("%6.0f",dfM)
	SSMstr=string("%10.3f",SSMin)
	MSSMstr=string("%10.3f",MSSMin)
	
	dfRstr=string("%6.0g",dfR)
        SSRin=MSSRin*dfR
	SSRstr=string("%10.3f",SSRin)
	MSSRstr=string("%10.3f",MSSRin)
		
	dfTstr=string("%6.0f",dfT)
	SSTin=MSSTin*dfT
        SSTstr=string("%10.f",SSTin)
	MSSTstr=string("%10.3f",MSSTin)
	
	Fvalue=(SSMin * dfR)/(SSRin * dfM)
	Fvalstr=string("  %10.3f", Fvalue)
	FPvalue=1-cdff(Fvalue,dfM,dfR)
	FPvalstr=string("   %1.4f", FPvalue)
	
	MultipR= sqrt(SSMin/SSTin)
	MultipRstr=string("Multiple R      = %7.5f",MultipR)
	Rsquare= SSMin/SSTin
	Rstr=string("R^2             = %7.5f",Rsquare)
	adRsquare= 1-((dfT*SSRin)/(dfR*SSTin))
	adRstr=string("Adjusted R^2    = %7.5f",adRsquare)
	StanEr= sqrt(MSSRin)
	StanErstr=string("Standard Error  = %7.5f",StanEr)
//TEXTOUTPUT	
	 
	anfirstline= "A  N  O  V  A                   SS      df     MSS       F-test   P-value"
	ansecondline="_________________________________________________________________________"
	anovatextMod= "Regression                "+SSMstr+dfMstr+MSSMstr+Fvalstr+FPvalstr
	anovatextRes= "Residuals                 "+SSRstr+dfRstr+MSSRstr
	anovatextTot= "Total Variation           "+SSTstr+dfTstr+MSSTstr	
	anovatext=""|anfirstline|ansecondline|anovatextMod|anovatextRes|anovatextTot|""|MultipRstr|Rstr|adRstr|StanErstr
		
	output= anovatext
endp