proc(output)=outputfs2(MultipR,Rsquare,Fvalue,FPvalue,colname,Vinn,Vin,Vi,k,Fin,dfM,dfR)
; -----------------------------------------------------------------------
; Library stats      
; -----------------------------------------------------------------------
; See_also outputbs outputpar outputstep outputanova    
; -----------------------------------------------------------------------
; Macro        outputfs2
; -----------------------------------------------------------------------
; Description  creates the parameter output for linregfs2
; -----------------------------------------------------------------------
; Notes        to be used only in context with the linear regression macros
;              or in context with "doista"
; -----------------------------------------------------------------------
 
 firstline="Forward Selection"
  secondline="------------------------------"
  finstr=string("%4.2f",Fin)
  entry=cdff(Fin,dfM,dfR)
  entrystr=string("%3.2f",entry)
  thirdline="F-to-enter "+finstr
  fourthline="probability of F-to-enter "+entrystr
  fifthline="Step  Multiple R      R^2        F        SigF       Variable(s)"
  stepstr=string("%2.0f ",1:k)
  MultipRstr=string("%10.4f  ",MultipR)
  Rstr=string("%11.4f  ",Rsquare)
  Fvalstr=string("%9.3f ", Fvalue)
  FPvalstr=string("%8.3f ", FPvalue)
  ;colname=string("%10.10s",colname)
  if(Vin<>0)
    variablestr=colname[Vinn]
  else
    variablestr="Constant  "
  endif
  instr=string("In: %s",variablestr)
  sixthline=stepstr+MultipRstr+Rstr+Fvalstr+FPvalstr+"   "+instr
  stepinstr=string("Step Number%2.0f",max(k))
  if(Vin<>0)
  variableinstr=colname[Vi]
  else
    variableinstr="Constant"
  endif
  seventhline="Variable entered at "+stepinstr+": "+variableinstr
  output=firstline|secondline|thirdline|fourthline|""|fifthline
  output=output|sixthline|""|seventhline
endp
