proc(output)=panunit(z,m,p,d,T)
; ---------------------------------------------------------------------
; Library     metrics
; ---------------------------------------------------------------------
; See_also    panfix, panrand, pandyn
; ---------------------------------------------------------------------
; Macro       panunit
; ---------------------------------------------------------------------
; Description Computes unit root statistics for panel data
; ---------------------------------------------------------------------
; Usage       (output)=panunit(z,m,p,d, {T})
; Input       
; Parameter   z   
; Definition     NT x {2+} k  data matrix
; Parameter   m  
; Definition     position of the variable to be tested 
;                (don't count the time and cross section index)
; Parameter   p  
; Definition     Number of Lagged differences  
; Parameter   d  
; Definition     =0 for no deterministics, =1 for a constant, =2 for trend
; Definition     Number of time periods for a BALANCED Dataset.               
;                Optional, only for a Dataset with the same T
;                for all Individuals = BALANCED PANEL     
; Output      
; Parameter   output 
; Definition     string with output table
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example      	library("metrics")
;              	z=read("dynpanel")
;		panunit(z,2,1,1)						panunit(z,2,0,1)
; ---------------------------------------------------------------------
; Result      
; [ 1,] "====================================================="
; [ 2,] "Pooled Dickey-Fuller Regression:  2'th variable      "
; [ 3,] "====================================================="
; [ 4,] "PARAMETERS        Estimate     robust SE      t-value"
; [ 5,] "====================================================="
; [ 6,] "Lag[1]=            -0.0822       0.0171        -4.819"
; [ 7,] "const=              0.0248       0.0758         0.327"
; [ 8,] "====================================================="
; [ 9,] "N*T=    378      N=   16           With constant     "
; [10,] "Unit root statistics:                                "
; [11,] "STATISTIC      Value  crit. Value (5%)  mean variance"
; [12,] "====================================================="
; [13,] "B/M (1994)     -2.319     -1.65       0.000     1.000"
; [14,] "L/L (1993)     -0.794     -1.65      -0.559     0.850"
; [15,] "mod. L/L       -1.501     -1.65       0.000     1.000"
; [16,] "I/P/S (1997)   -1.425     -1.65      -1.526     0.713"
; [17,] "====================================================="
; Keywords    
; ---------------------------------------------------------------------
; Reference   
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Joerg Breitung 
; ---------------------------------------------------------------------
  NT=rows(z)
  k=cols(z)  
 
  if (exist(T))  

    error(p>T-1,       "  p must be smaller than T")

    if (T>0)
      N=NT/T
      error(N-floor(N)>0,"  The data set is not balanced (NT/N is not an integer)")
      error(T<2,         "  T must be at least 2")
      ind=(1:N)  
      ind=kron(ind,matrix(T,1))
      z=ind~z
      k=k+2 
    endif
  else
    z=z[,1]~z[,3:k]
    k=k-1 
	endif	 

; Eingabeanalyse

    error(m>k-1,       "  m must be smaller than the number of variables")
    error(m<1  ,       "  m must be at least 1")
    error(p<0,         "  p must be positive")
    error(d>2,         "  d must be at most 2")
    error(d<0,         "  d must be at least 0")



        /*   a la Breitung/Meyer (1994)  */
  sxx=0
  sxy=0
  sxx1=0
  sxy1=0
  N=0
  pos=1
  while(pos < NT-1) 
    ind=z[pos,1]
    yi=z[pos,m+1]
    pos=pos+1
    while (z[pos,1]==ind)
      yi=yi|z[pos,m+1]
      pos=pos+1
    endo
    Ti=rows(yi)

    x=yi[p+1:Ti-1]
    x1=yi[p+1:Ti-1]-yi[1]
    j=1
    while (j<=p)
      x=x~(yi[p+2-j:Ti-j]-yi[p+1-j:Ti-j-1])
    j=j+1
    endo

    if (d>0)
      x=x~matrix(Ti-p-1,1)
      if (d==2)
        x=x~#(1:Ti-p-1)
      endif   
    endif
    x1=x1~x[,2:cols(x)]

    y=yi[p+2:Ti]-yi[p+1:Ti-1]    
    sxx=sxx+x'*x
    sxy=sxy+x'*y
    sxx1=sxx1+x1'*x1
    sxy1=sxy1+x1'*y
    N=N+1  
  endo 

  bbm=inv(sxx)*sxy
  bbm1=inv(sxx1)*sxy1

            /*  robust standard errors  */
  sxuux=0
  sxuux1=0
  pos=1
  while(pos < NT-1) 
    ind=z[pos,1]
    yi=z[pos,m+1]
    pos=pos+1
    while (z[pos,1]==ind)
      yi=yi|z[pos,m+1]
      pos=pos+1
    endo
    Ti=rows(yi)

    x=yi[p+1:Ti-1]
    x1=yi[p+1:Ti-1]-yi[1]
    x=yi[p+1:Ti-1]
    x1=yi[p+1:Ti-1]-yi[1]
    j=1
    while (j<=p)
      x=x~(yi[p+2-j:Ti-j]-yi[p+1-j:Ti-j-1])
    j=j+1
    endo

    if (d>0)
      x=x~matrix(Ti-p-1,1)
      if (d==2)
        x=x~#(1:Ti-p-1)
      endif   
    endif
    x1=x1~x[,2:cols(x)]

    y=yi[p+2:Ti]-yi[p+1:Ti-1]    
    u=y-x*bbm
    u1=y-x1*bbm1
    sxuux=sxuux+x'*u*u'*x
    sxuux1=sxuux1+x1'*u1*u1'*x1
  endo 
 
  SEbbm=inv(sxx)*sxuux*inv(sxx)
  SEbbm=sqrt(xdiag(SEbbm))	
  SEbbm1=inv(sxx1)*sxuux1*inv(sxx1)
  SEbbm1=sqrt(xdiag(SEbbm1))	 
  Tbbm=bbm./SEbbm   
  Tbbm1=bbm1./SEbbm1   
 
                       /*   a la Levin-Lin and PSI  */
  T0=floor(NT/N)
    sxy=0
    sta=0
    sEv=0
    sig=0 
    som=0
    svv=0 
    sev=0
    sevadj=0
    see=0
    s10=0
    s11=0
    NT0=0
    trunc=floor(2*exp(log(T0)/3))
    m1=0 
    m2=1
    if (d==1)
       m1= -0.493 -0.1813/sqrt(T0)-0.922/T0 
       m2=0.693+0.566/sqrt(T0)+0.588/T0 
       mua=  -1.526 - 0.107/T0 + 0.9124*p/T0   
       vara=0.7207 + 52/T0^2 + 0.4353*p/T0^2
    endif 
    if (d==2)
       m1= -0.4747-0.544/sqrt(T0)-3.321/T0
       m2=0.40156+ 2.833/sqrt(T0)-1.68185/T0
       mua=-2.177-0.0554/T0+0.6576*p/T0+0.1314*p^2/T0
       vara= 0.5784+60.444/T0^2+14.57*p^2/T0^2
    endif  
   
    pos=1
    while(pos < NT-1) 
      ind=z[pos,1]
      yi=z[pos,m+1]
      pos=pos+1
      while (z[pos,1]==ind)
        yi=yi|z[pos,m+1]
        pos=pos+1
      endo
      Ti=rows(yi)
      T0i=Ti-p-1
      NT0=NT0+T0i

      dy0=yi[2:Ti]-yi[1:Ti-1]    
      dy=yi[p+2:Ti]-yi[p+1:Ti-1]    

      x=0*matrix(T0i,1)
      x1=0*matrix(T0i,1)
      j=1
      while (j<=p)
        x=x~(yi[p+2-j:Ti-j]-yi[p+1-j:Ti-j-1])
        x1=x1~yi[p+1-j:Ti-j-1]
        j=j+1 
      endo

      if (d>0)
        dt=matrix(Ti-1,1)
        if (d==2)
          dt=dt~#(1:Ti-1)     
        endif
        dy0=dy0-dt*inv(dt'*dt)*dt'*dy0
        dt=dt[1:T0i,]
        x=x~dt
      endif
      x=x[,2:cols(x)]
      x1=x1[,2:cols(x)]
      y1=yi[p+1:Ti-1]

      if (p+d>0)
        du=dy-x*inv(x'*x)*x'*dy
        u1=y1-x*inv(x'*x)*x'*y1
      else
        du=dy
        u1=y1
      endif
             
      a=u1'*du/u1'*u1  
      x=x[,1:cols(x)-1]~y1
      b=inv(x'*x)*x'*dy
      sigi=(du'*du-a*du'*u1)/(T0i-d-p-1);
      sigi=sqrt(sigi)

      if (d==1)
        if (p>=1)
          dv=dy-x[,1:p]*b[1:p]
        else
          dv=dy[2:T0i]
        endif   
        jmin=max(2|(p+1))
        v1=yi[jmin:Ti-1]-yi[1]
        dv=dv/sigi
        v1=v1/sigi
        s10=s10+v1'*dv
        s11=s11+v1'*v1
      endif
 
      if (d==2)
        if (p>=1)
          dv=dy-x[,1:p]*b[1:p]
          v1=y1-x1[,1:p]*b[1:p]
        else
          dv=dy
          v1=y1
        endif
        dv=dv/sigi
        v1=v1/sigi
        j=1
        while (j<=T0i-1)
          dv[j]=(T0i-j)*(dv[j]-mean(dv[j+1:T0i]))/(T0i-j+1)
          v1[j]=v1[j]-(j-1)*(v1[T0i]+dv[T0i])/T0i
          j=j+1
        endo
        v1=v1-v1[1]
        s10=s10+v1'*dv 
        s11=s11+v1'*v1
      endif

      if (d<=1)    
        om=newest(dy0,trunc)
      endif
      if (d==2)
        om=newest(dy0-mean(dy0),trunc) 
      endif
      omsqrt=sqrt(om) 
      
      du=du/sigi
      u1=u1/sigi
      sev=sev+du'*u1 
      sevadj=sevadj + du'*u1 - T0i*m1*omsqrt/sigi
      svv=svv+u1'*u1
      see=see+du'*du

      ta=a*sqrt(u1'*u1)
      sta=sta+ta
    endo

    sig0=(see-sev*svv*sev')/NT
sig0
    levlin=sevadj/sqrt(svv)/m2/sqrt(sig0)

    if (d>0)
      modLL=s10/sqrt(s11)
      IPS=(sta-N*mua)/sqrt(N*vara)
    endif

  betastr=string("Lag[1]=    %15.4f", bbm[1])	
	betasestr=string("     %8.4f",SEbbm[1])
	tvalstr=string("  %12.3f", Tbbm[1])  
  if (p>=1)
    betastr=betastr|string("Delta[%2.0f]= %15.4f", 1:p, bbm[2:2+p-1])	
  	betasestr=betasestr|string("     %8.4f",SEbbm[2:2+p-1])
  	tvalstr=tvalstr|string("  %12.3f", Tbbm[2:2+p-1])  
  endif   
  detstr=" Without deterministic terms"
  if (d>0)
    betastr=betastr|string("const=     %15.4f", bbm[p+2])	
  	betasestr=betasestr|string("     %8.4f",SEbbm[p+2])
  	tvalstr=tvalstr|string("  %12.3f", Tbbm[p+2])  
    detstr="          With constant     "
    if (d==2)
      betastr=betastr|string("trend=     %15.4f", bbm[p+3])	
    	betasestr=betasestr|string("     %8.4f",SEbbm[p+3])
    	tvalstr=tvalstr|string("  %12.3f", Tbbm[p+3])  
      detstr="    With linear trend       "
    endif
  endif
  DFstr=string("N*T=%7.0f",NT)
  DFstr=DFstr+string("      N=%5.0f ",N)
  DFstr=DFstr+detstr
  test1=string("B/M (1994)  %9.3f  ",Tbbm1[1])
  test1=test1+"   -1.65   " 
  test1=test1+string("    %5.3f  ",0)
  test1=test1+string("   %5.3f",1)
    test2=string("L/L (1993)  %9.3f  ",levlin)
    test2=test2+"   -1.65   "
    test2=test2+string("   %6.3f  ",m1)
    test2=test2+string("   %5.3f",m2)
    if (d>0)
      test3=string("mod. L/L    %9.3f  ",modLL)
      test3=test3+"   -1.65   "
      test3=test3+string("   %6.3f  ",0)
      test3=test3+string("   %5.3f",1)
      test4=string("I/P/S (1997)%9.3f  ",IPS)
      test4=test4+"   -1.65   "
      test4=test4+string("   %6.3f  ",mua)
      test4=test4+string("   %5.3f",vara)
    endif

  
  line1=string("Pooled Dickey-Fuller Regression: %2.0f'th variable      ",m)
	line2="=====================================================" 
	line3="PARAMETERS        Estimate     robust SE      t-value"    
	line4="Unit root statistics:                                "
	line5="STATISTIC      Value  crit. Value (5%)  mean variance"    
	parametertext=betastr+betasestr+tvalstr 
	output=line2|line1|line2|line3|line2|parametertext|line2|DFstr
  output=output|line4|line5|line2|test1
  output=output|test2
  output=output|test3|test4|line2

endp 

   

