proc(phi)=phigen(coeff,j,anz,ord,di,typ)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  hgen
; ----------------------------------------------------------------------
;   Macro	  phigen
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for full VAR model analysis
; ----------------------------------------------------------------------
;   Usage         phi = phigen(coeff,j,anz,ord,di,typ)
;   Input 
;     Parameter   coeff 
;     Definition     vector 
;     Parameter   j 
;     Definition     vector 
;     Parameter   anz 
;     Definition     integer  
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   typ 
;     Definition     integer, describing the model type
;   Output
;     Parameter   phi
;     Definition     matrix
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Sperlich 971106
; ----------------------------------------------------------------------
phi=eye(di)
if (typ==6)
   if (ord ==0)
        phi=kron( phi|ones(anz,1), zeros(di,di) )
   else
      h=hgen(ord,di)
      i=1
      while (i<=anz)
         phi=phi|(j*power(coeff,i)*h)
         i=i+1
      endo
   endif
else
   if (ord ==0)
        phi=kron( (phi|ones(anz,1)), zeros(di,di) )
   else
      i=1
      while (i<=anz)
         phi=phi|(j*power(coeff,i)*j')
         i=i+1
      endo
   endif
endif
endp
