proc() = plot2 (x, prep, col)
; -----------------------------------------------------------------------
; Library      plot
; -----------------------------------------------------------------------
; See_also     transform plotandrews plotstar plotsplom plotgt
; -----------------------------------------------------------------------
; Macro        plot2
; -----------------------------------------------------------------------
; Description  Plots the first two columns from a multivariate dataset.
; -----------------------------------------------------------------------
; Usage        plot2 (x {, prep {, col}})
; Input
;   Parameter  x
;   Definition n x p matrix
;   Parameter  prep
;   Definition scalar
;   Parameter  col
;   Definition color
; -----------------------------------------------------------------------
; Notes        prep allows some transformation of the data:
;
;              grc.prep.none (0) - no transformation   (default)
;
;              grc.prep.standard (1) - standardize
; 
;              grc.prep.zeroone (2) - to [0,1]
;
;              grc.prep.pcacov (3) - pca on cov matrix
;
;              grc.prep.pcacorr (4) - pca on corr matrix
;
;              grc.prep.sphere (5) - sphering
; -----------------------------------------------------------------------
; Example      ; loads the library plot
;              library ("plot")
;              ; reads the swiss banknote data (200x6)
;              x = read("bank2")
;              ; computes the principal components of x
;              plot2 (x, grc.prep.pcacov)
; -----------------------------------------------------------------------
; Result       shows the first two principal components of x
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords    high level graphics
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970201
; -----------------------------------------------------------------------
  grc = getglobal ("grc")  
  if (exist("prep").<>1)
    prep = grc.prep.none
  endif
  if (exist("col").<>1)
    col = grc.col.black
  endif
  y = transform (x, prep)
  setmaskp (y, col, 3, 8)
  grdisp = createdisplay(1,1)
  show (grdisp, 1, 1, y)
endp
