proc() = plotandrews (x, prep, col)
; -----------------------------------------------------------------------
; Library      plot
; -----------------------------------------------------------------------
; See_also     grandrews plot2 plotpcp plotsplom
; -----------------------------------------------------------------------
; Macro        plotandrews 
; -----------------------------------------------------------------------
; Description  Plots  andrews curves from a multivariate dataset andrews.
; -----------------------------------------------------------------------
; Usage        plotandrews (x {, prep {, col}})
; Input
;   Parameter  x
;   Definition n x p matrix
;   Parameter  prep
;   Definition scalar
;   Parameter  col
;   Definition color
; -----------------------------------------------------------------------
; Notes        prep allows some transformation of the data:
;
;              grc.prep.none (0) - no transformation
;
;              grc.prep.standard (1) - standardize
;
;              grc.prep.zeroone (2) - to [0,1]
;
;              grc.prep.pcacov (3) - pca on cov matrix (default)
;
;              grc.prep.pcacorr (4) - pca on corr matrix
;
;              grc.prep.sphere (5) - sphering
; -----------------------------------------------------------------------
; Example      ; loads the library plot
;              library ("plot")
;              ; reads the swiss banknote data (200x6)
;              x = read("bank2")
;              ; computes the principal components of x as andrews curves
;              plotandrews (x, grc.prep.pcacov)
; -----------------------------------------------------------------------
; Result       shows the principal components of x as andrews curves
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords    high level graphics, andrews curves
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970201
; -----------------------------------------------------------------------
  grc = getglobal ("grc")  
  if (exist("prep").<>1)
    prep = grc.prep.pcacov
  endif
  if (exist("col").<>1)
    col = grc.col.black
  endif
  y = transform (x, prep)
  gry = grandrews(y, 50, col)
  grdisp = createdisplay(1,1)
  show (grdisp, 1, 1, gry)
endp
