proc()=plotface(obsrv,p,n,pc)
; -----------------------------------------------------------------------
; Library      plot 
; -----------------------------------------------------------------------
; Macro        plotface
; -----------------------------------------------------------------------
; See_also     grface
; -----------------------------------------------------------------------
; Description  plots and prints Flury faces interactively                    
; -----------------------------------------------------------------------
; Notes		List of face parameters (right, left): 
;       eye size                        (1,       19),
;       pupil size                      (2,       20),
;       position of pupil               (3,       21),
;       eye slant                       (4,       22),
;       horizontal position of eye      (5,       23),
;       vertical position of eye        (6,       24),
;       curvature of eyebrow            (7,       25),
;       density of eyebrow              (8,       26),
;       horizontal position of eyebrow  (9,       27),
;       vertical position of eyebrow    (10,      28),
;       upper hairline                  (11,      29),
;       lower hairline                  (12,      30),
;       face line                       (13,      31),
;       darkness of hair                (14,      32),
;       hair slant                      (15,      33),
;       nose line                       (16,      34),
;       size of mouth                   (17,      35),
;       curvature of mouth              (18,      36).
;
; -----------------------------------------------------------------------
; Keywords    multivariate analysis, Flury faces
; -----------------------------------------------------------------------
; Usage       plotface(obsrv,q,fl,fc)
; Input     
;  Parameter  obsrv
;  Definition n x p matrix with the observations
;  Parameter  q
;  Definition 1 x 36 matrix with the assignments to the face parts
;  Parameter  fl
;  Definition scalar, faces per line
;  Parameter  fc
;  Definition scalar, faces per column
; -----------------------------------------------------------------------
; Example
;    library("plot")
;    q=0.*matrix(1,36)   ; do not use any facepart
;    q[,1] =1            ; right eye size
;    q[,19]=1            ; left eye size
;    q[,2] =2            ; right pupil size
;    q[,20]=2            ; left pupil size 
;    q[,4] =3            ; right eye slant
;    q[,22]=3            ; left eye slant
;    q[,11]=4            ; right upper hair line
;    q[,29]=4            ; left upper hair line
;    q[,12]=5            ; right lower hairline
;    q[,30]=5            ; left lower hairline
;    q[,13]=6            ; right face line
;    q[,14]=6            ; right darkness of hair
;    q[,31]=6            ; left face line
;    q[,32]=6            ; left darkness of hair
;    h=read("bank2")
;    plotface(h,q,5,5)       
; -----------------------------------------------------------------------
; Result    Plot of flury faces
; -----------------------------------------------------------------------
; Author    Fabian Noetzel, Sigbert Klinke
; -----------------------------------------------------------------------
;  error (n*p>30, "plotface: can not show more than 30 faces")
  error (n*p>rows(obsrv), "plotface: can not show more faces then observations")
  scal = sum((min(obsrv)<0)+(max(obsrv)>1), 2)
  if (scal)
    error (rows(obsrv)==1, "plotface: can not scale only one observation")
    obsrv=(obsrv-min(obsrv))./(max(obsrv)-min(obsrv))
  endif
  i=0
  axesoff()
  buf1=1
  buf2=n*pc
  max = rows(obsrv)
  obs=obsrv[buf1:buf2,]
  draw=grface(obs,p,n)
  Faces = createdisplay(1, 1)
  show(Faces, 1, 1, draw)
  s1=string("Observations %.0f to %.0f", buf1, buf2)
  setgopt(Faces,1,1,"title",s1)
  selitem="next page"|"next line"|"print"|"last line"|"last page"
  selhead="Flury Faces"
  continue=1
  flag=0
  while (continue<>0)
    sel=selectitem(selhead, selitem)
    m=sum(sel)
    if (sel[1]==1)
      newbuf1=buf2+1
      newbuf2=buf2+n*pc
    endif
    if (sel[2]==1)
      newbuf1=buf1+n
      newbuf2=buf2+n
    endif
    if (sel[4]==1)
      newbuf1=buf1-n
      newbuf2=buf2-n
    endif
    if (sel[5]==1)
      newbuf2=buf1-1    
      newbuf1=buf1-n*pc
    endif
    if (sel[3]==1)
      i=i+1
      item = "Filename"
      def  = string("faces%.0f.ps",i)                   ; sets the default values
      file = readvalue(item, def)
      print(Faces, file)
      newbuf1=buf1
      newbuf2=buf2
    endif
    if (sum(sel)==0)
      newbuf1=buf1
      newbuf2=buf2
    endif
    if (newbuf1<1)
      newbuf2=n*pc
      newbuf1=1
      flag=1
    endif
    if (newbuf2>max)
      newbuf2=max
      newbuf1=max-n*pc+1
      flag=1
    endif
    if ((newbuf1<>buf1) || (newbuf2<>buf2))
      buf1=newbuf1
      buf2=newbuf2
      obs=obsrv[buf1:buf2,]
      draw=grface(obs,p,n)
        s1=string("Observations %.0f to %.0f", buf1, buf2)
      show(Faces, 1, 1, draw)
      setgopt(Faces,1,1,"title",s1)
    endif
    continue=(m>0)
  endo
  axeson()
endp