proc()=plotgt(l)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plot2 plotandrews plotpcp plotsplom
; -----------------------------------------------------------------------
; Macro        plotgt
; -----------------------------------------------------------------------
; Description  Interactive grand tour and projection pursuit methods of 
;              a multivariate dataset. 
; -----------------------------------------------------------------------
; Usage        plotgt (l)
; Input
;   Parameter  l
;   Definition n x p matrix or a list
;   Parameter  l.x
;   Definition l.prep
;   Definition scalar
;   Parameter  l.col
;   Definition color
; -----------------------------------------------------------------------
; Notes        Only runnable under UNIX and Linux !
;              To stop the grand tour move the mouse in the display and
;              and press any key.
;
;              option allows some transformation on x:
;              grc.prep.inter     -1     interactive selection
;              grc.prep.none       0     no transformation    
;              grc.prep.standard   1     standardize
;              grc.prep.zeroone    2     to [0,1]
;              grc.prep.pcacov     3     pca on cov matrix    
;              grc.prep.pcacorr    4     pca on corr matrix
;              grc.prep.sphere     5     sphering               (default)
;
; -----------------------------------------------------------------------
; Example      ; loads the library pp
;              library ("pp")
;              ; reads the swiss banknote data (200x6)
;              x = read("bank2")
;              ; executes the grand tour 
;              plotgt (x)
; -----------------------------------------------------------------------
; Result       shows the grand tour 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords    high level graphics, grand tour, exploratory projection pursuit
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970418
; -----------------------------------------------------------------------
;  setsize (350,400)
  setsize(300,400)
  grc      = getglobal("grc")
  col    = grc.col.black
  option = grc.prep.sphere|0|0.01/cols(l)
  if (exist("l")==9)
    ln = names(l)
    i = 0
    while (i<rows(ln))
      i = i+1
      if (ln[i]=="x")
        x = l.x
        p = cols(x)
      endif
      if (ln[i]=="col")
        col = l.col
      endif
      if (ln[i]=="prep")
        option = l.prep|0|0.01/p
      endif
    endo
  else
    x  = l
  endif
  p        = cols(x) 
  error(p>rows(grc.prime), "plotgt: cols(x) too large")
  error(p<4, "plotgt: cols(x)<4")
  y = transform (x, option[1])
  tourdisp = createdisplay(2,1)
  setfractions (tourdisp, 3|1, 1)
  outtext ="Press space bar"|"to break the tour"
  show (tourdisp, 2, 1, outtext)
  rotm     = ((1:p).=trans(1:p))
  bs       = 10
  setmaskp (y, col, 3, 4)
  show (tourdisp, 1, 1, y)
  setmode (tourdisp, 1, 1, 1)
; change internal values 
  acttitle = "Grand Tour (Little)"
  gopt = getgopt(tourdisp, 1, 1)
  ofscal = gopt.scal
  gopt.brushsize = 10.*matrix(4)
  gopt.rotpoint  = 0.*matrix(1,cols(x))
  gopt.rotcos    = rotm
  gopt.title     = acttitle
  sws            = 34.722222222
; you may change the 2 !!
  gopt.fscal     = 2*sws/max(sqrt(sum(y^2,2)))*((1:cols(x))==(1:cols(x))')
  setgopt (tourdisp, 1, 1, gopt)
  selitem  = "Change method"|"Change speed"|"Shift colors"|"Brush size"|"Continue tour"
;  selmtd = 1
  selmtdhead = "Methods"
  selmtditem = "Asimov Grand Tour"|"Random Grand Tour"|"Little Grand Tour"
  selmtditem = selmtditem|"Friedman Tukey Index"|"Entropy Index"
  selmtditem = selmtditem|"Legendre Index"|"Hermite Index"|"Natural Hermite Index"
  mtdasimov  = 1
  mtdrandom  = 2
  mtdlittle  = 3
  mtdft      = 4
  mtdet      = 5
  mtdleg     = 6
  mtdher     = 7
  mtdnher    = 8
  selmtd  = mtdlittle
  selhead = selmtditem[selmtd]
; generate all parameters
  history = reshape(rotm, #(1,p,p))
  tourparam = list (history, col) 
; parameters for asimov tour
  ta    = 0 
  gopt  = getgopt (tourdisp, 1, 1)
  tarot = gopt.rotcos
  tadt  = 0.01/p
  append (tourparam, ta);
  append (tourparam, tarot);
  append (tourparam, tadt);
; parameters for random tour
  tr    = 0
  tra   = 0.*matrix(p*(p-1)/2)
  trrot = gopt.rotcos
  trdt  = 0.01/p
  append (tourparam, tr);
  append (tourparam, tra);
  append (tourparam, trrot);
  append (tourparam, trdt);
; parameters for little tour
  tl    = 0
  tla   = 0.*matrix(p*(p-1)/2)
  tlrot = gopt.rotcos
  tldt  = 0.01/p
  append (tourparam, tl);
  append (tourparam, tla);
  append (tourparam, tlrot);
  append (tourparam, tldt);
; parameters for epp friedman tukey
  eft    = 0
  eftrot = gopt.rotcos
  eftdt  = 0.01/p
  eftind = -Inf
  efth   = 3.12/rows(x)^(1/6)
  append (tourparam, eft);
  append (tourparam, eftrot);
  append (tourparam, eftdt);
  append (tourparam, eftind);
  append (tourparam, efth);
; parameters for epp entropy
  eet    = 0
  eetrot = gopt.rotcos
  eetdt  = 0.01/p
  eetind = -Inf
  eeth   = 3.12/rows(x)^(1/6)
  append (tourparam, eet);
  append (tourparam, eetrot);
  append (tourparam, eetdt);
  append (tourparam, eetind);
  append (tourparam, eeth);
; parameters for epp legendre
  elegt   = 0
  elegrot = gopt.rotcos
  elegdt  = 0.01/p
  elegind = -Inf
  elegh   = 3.12/rows(x)^(1/6)
  append (tourparam, elegt);
  append (tourparam, elegrot);
  append (tourparam, elegdt);
  append (tourparam, elegind);
  append (tourparam, elegh);
; parameters for epp hermite
  ehert   = 0
  eherrot = gopt.rotcos
  eherdt  = 0.01/p
  eherind = -Inf
  eherh   = 3.12/rows(x)^(1/6)
  append (tourparam, ehert);
  append (tourparam, eherrot);
  append (tourparam, eherdt);
  append (tourparam, eherind);
  append (tourparam, eherh);
; parameters for epp natural hermite
  enht   = 0
  enhrot = gopt.rotcos
  enhdt  = 0.01/p
  enhind = -Inf
  enhh   = 3.12/rows(x)^(1/6)
  append (tourparam, enht);
  append (tourparam, enhrot);
  append (tourparam, enhdt);
  append (tourparam, enhind);
  append (tourparam, enhh);
  do
    do
      switch 
      case (selmtd==mtdrandom)
        gopt  = getgopt (tourdisp, 1, 1)
        {rotm, tourparam} = tourrandom(tourparam, gopt.rotcos)
        break
      case (selmtd==mtdlittle)
        gopt  = getgopt (tourdisp, 1, 1)
        {rotm, tourparam} = tourlittle(tourparam, gopt.rotcos)
        break
      case (selmtd==mtdft)
        {rotm, tourparam} = eppft(tourparam, y)
        break
      case (selmtd==mtdet)
        {rotm, tourparam} = eppet(tourparam, y)
        break
      case (selmtd==mtdleg)
        {rotm, tourparam} = eppleg(tourparam, y)
        break
      case (selmtd==mtdher)
        {rotm, tourparam} = eppher(tourparam, y)
         break
      case (selmtd==mtdnher)
        {rotm, tourparam} = eppnh(tourparam, y)
        break
      default
        {rotm, tourparam} = tourasimov(tourparam, grc.prime)
      endsw
      setgopt (tourdisp, 1, 1, "rotcos", rotm) 
      evt = readevent(0)
    until (evt)   
    cont = 0
    do
      sel = selectitem (selhead, selitem, "single")
      end = (sum(sel).=0)
      if (end)
        cont = 1
      endif
      if (sel[1])
        newmtd = selectitem(selmtdhead, selmtditem, "single")
        newmtd = sum(newmtd.*(1:8))
        selhead = selmtditem[selmtd]
        gopt = getgopt (tourdisp, 1, 1)
        switch
          case(newmtd==mtdasimov)
            tourparam.tarot = gopt.rotcos
            tourparam.ta    = 0
            acttitle        = "Grand Tour (Asimov)"
            break
          case(newmtd==mtdrandom)
            tourparam.trrot = gopt.rotcos
            tourparam.tr    = max(abs(tourparam.tra))
            acttitle        = "Grand Tour (Random)"
            break
          case(newmtd==mtdlittle)
            tourparam.tlrot = gopt.rotcos
            tourparam.tl    = max(abs(tourparam.tla))
            acttitle        = "Grand Tour (Little)"
            break
          case(newmtd==mtdft)
            tourparam.eft    = 0
            tourparam.eftrot = gopt.rotcos
            tourparam.eftind = -Inf
            tourparam.efth   = readvalue ("Bandwitdh", tourparam.efth)
            acttitle         = string ("Friedman-Tukey (h=%g)", tourparam.efth)
            break
          case(newmtd==mtdet)
            tourparam.eet    = 0
            tourparam.eetrot = gopt.rotcos
            tourparam.eetind = -Inf
            tourparam.eeth   = readvalue ("Bandwitdh", tourparam.eeth)
            acttitle         = string ("Entropy (h=%g)", tourparam.eeth)
            break
          case(newmtd==mtdleg)
            tourparam.elegt   = 0
            tourparam.elegrot = gopt.rotcos
            tourparam.elegind = -Inf
            tourparam.elegh   = readvalue ("Bandwitdh", tourparam.elegh)
            acttitle          = string ("Legendre (h=%g)", tourparam.elegh)
            break
          case(newmtd==mtdher)
            tourparam.ehert   = 0
            tourparam.eherrot = gopt.rotcos
            tourparam.eherind = -Inf
            tourparam.eherh   = readvalue ("Bandwitdh", tourparam.eherh)
            acttitle         = string ("Hermite (h=%g)", tourparam.eherh)
            break
          case(newmtd==mtdnher)
            tourparam.enht   = 0
            tourparam.enhrot = gopt.rotcos
            tourparam.enhind = -Inf
            tourparam.enhh   = readvalue ("Bandwitdh", tourparam.enhh)
            acttitle         = string ("Natural Hermite (h=%g)", tourparam.enhh)
            break
        endsw
        setgopt (tourdisp, 1, 1, "title", acttitle)
        selmtd = newmtd
        cont = 1
      endif
      if (sel[2])
        switch 
          case (selmtd==mtdasimov)
            tourparam.tadt = readvalue ("Speed", tourparam.tadt)
            break;
          case (selmtd==mtdrandom)
            tourparam.trdt = readvalue ("Speed", tourparam.trdt)
            break;
          case (selmtd==mtdlittle)
            tourparam.tldt = readvalue ("Speed", tourparam.tldt)
            break;
          case (selmtd==mtdft)
            tourparam.eftdt = readvalue ("Speed", tourparam.eftdt)
            break;
          case (selmtd==mtdet)
            tourparam.eetdt = readvalue ("Speed", tourparam.eetdt)
            break;
          case (selmtd==mtdleg)
            tourparam.elegdt = readvalue ("Speed", tourparam.elegdt)
            break;
          case (selmtd==mtdher)
            tourparam.eherdt = readvalue ("Speed", tourparam.eherdt)
            break;
          case (selmtd==mtdnher)
            tourparam.enhdt = readvalue ("Speed", tourparam.enhdt)
            break;
         endsw
        cont = 1
      endif
;      if (sel[2])
;        dt    = -dt
;        cont = 1
;     endif
      if (sel[3])
        data   = getdata (tourdisp, 1,1,1)
        gopt   = getgopt (tourdisp, 1,1)
        pcolor = data.pcolor
        pstyle = data.pstyle
        psize  = data.psize
        pdata  = data.data
        cind = 0*matrix(rows(pcolor))
        cind = cind+1*(sum(pcolor==grc.rgb.black, 2)==3)
        cind = cind+2*(sum(pcolor==grc.rgb.blue, 2)==3)
        cind = cind+3*(sum(pcolor==grc.rgb.green, 2)==3)
        cind = cind+4*(sum(pcolor==grc.rgb.cyan, 2)==3)
        cind = cind+5*(sum(pcolor==grc.rgb.red, 2)==3)
        cind = cind+6*(sum(pcolor==grc.rgb.magenta, 2)==3)
        cind = cind+0*(sum(pcolor==grc.rgb.yellow, 2)==3)
        setmaskp (pdata, cind, pstyle, psize)
        gopt   = getgopt (tourdisp, 1,1)
        show (tourdisp, 1, 1, pdata)
        setmode (tourdisp, 1, 1, 1)
        setgopt (tourdisp, 1, 1, gopt)
      endif
      if (sel[4])
        bs = readvalue ("Brush size (0-50)", bs)
        setgopt (tourdisp, 1, 1, "brushsize", bs|bs)
      endif
      if (sel[5])
        cont = 1
      endif
    until (cont)
  until (end)
endp
