proc(y)=pred(tr,x,type)
;The program pred.xpl calls holmo.xpl, endpoint.xpl.
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also      cartsplit, cartsplitopt, cartcv, leafnum, maketr,  
;             prederr, prune, prunecv, pruneseq, prunetot, ssr, kuva
; -----------------------------------------------------------------------
; Macro        pred
; -----------------------------------------------------------------------
; Description  Given a regression tree m (output of cartsplit) 
;              and a vector x, returns m(x), that is,
;              the predicton of the tree on that point.
; -----------------------------------------------------------------------
; Usage         enn = pred (tr, x, type)
; Input        
;   Parameter  tr
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors 
;               tr.val, tr.vec, tr.mean, tr.ssr, tr.nelem.
;               See cartsplit for the description of tr.
;   Parameter  x
;   Definition  p x 1 vector: represents a point in the sample space
;               at which the prediction of the regression tree will
;               be given. 
;  Parameter  type
;  Definition  p x 1 vector: 
;              contains the types of the original regression variables,
;              1 means that the corresponding variable is continuous and
;              0 that it is categorical. This vector should be similar to
;              the vector which was given originally as an input to the
;              cartsplit which produced the regression tree tr. 
; Output        
;   Parameter  enn
;   Definition real number: prediction of the regression tree at x,
;              that is, the value of the regression function at x. 
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
; ;let us generate a tree by cartsplit procedure
; x1=#(0,0,0,0,1,1,1,1,1,2)
; x2=#(0,0,0,0,0,0,0,1,1,1)
; x=x1~x2
; y=#(0,0,0,0,100,100,100,120,120,120)
; tr=cartsplit(x,y,#(0,1))
; tr
; enn1=pred(tr,#(0,1),#(0,1))
; enn1
; enn2=pred(tr,#(1,-1),#(0,1))
; enn2
; enn3=pred(tr,#(1,1),#(0,1))
; enn3
; -----------------------------------------------------------------------
; Result  
; Content of object tr.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object tr.val.split1
; [1,] NaN 
; Content of object tr.val.split2
; [1,] 0 
; Content of object tr.val.split3
; [1,] NaN 
; Content of object tr.val.split4
; [1,] NaN 
; Content of object tr.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] 2.000000 
; [4,] NaN 
; [5,] NaN 
; Content of object tr.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; [4,] 100.000000 
; [5,] 120.000000 
; Content of object tr.var
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; [4,] 0.000000 
; [5,] 0.000000 
; Content of object tr.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; [4,] 3.000000 
; [5,] 3.000000 
; 
; Content of object enn1
; [1,] 0.000000
; Content of object enn2
; [1,] 100.000000
; Content of object enn3
; [1,] 120.000000
; -----------------------------------------------------------------------
; Author       Jussi Klemelae, 980323         
; -----------------------------------------------------------------------
inde=1
jakovar=tr.vec[inde]
while (jakovar!=NaN)
   if (type[jakovar]==0)
       test=holmo(x[jakovar],tr.val{inde}[1])
       if (test)  
          inde=inde+1
       else 
          inde=endpoint(tr,inde+1)+1
       endif
    else
       if (x[jakovar]<=atof(tr.val{inde}))  
          inde=inde+1
       else 
          inde=endpoint(tr,inde+1)+1
       endif
   endif  
   jakovar=tr.vec[inde]
endo
y=tr.mean[inde]
endp
    
          
