proc(y)=pruneseq(tree)
;The program prune.xpl calls 
;endpoint.xpl, gform.xpl, init.xpl, leafnum.xpl, 
;maketr.xpl, ssr.xpl, final.xpl, suitind.xpl,
;omaind.xpl.
; -----------------------------------------------------------------------
; Library      xclust
; -----------------------------------------------------------------------
; See_also     cartsplit, cartsplitopt, cartcv, leafnum, maketr,  pred,
;              prederr, prune, prunecv, prunetot, ssr, kuva
; -----------------------------------------------------------------------
; Macro        pruneseq
; -----------------------------------------------------------------------
; Description  Gives the numbers of leaves and the values of the 
;              complexity parameters in the sequence of subtrees,
;              pruned from a tree which has been 
;              created by the cartsplit procedure.
;              Prunes using error-complexity criterion. 
; -----------------------------------------------------------------------
; Usage         seq = pruneseq (cs)
; Input        
;   Parameter  cs
;   Definition  list of vectors: data structure which represents a binary tree
;               and is produced by cartsplit procedure, contains vectors 
;               cs.val, cs.vec, cs.mean, cs.ssr, cs.nelem.
;               See cartsplit for the description of cs.  
; Output       
;   Parameter  seq
;   Definition  list of vectors: consists of seq.lnumber, seq.alfa.
;               The elements of seq are vectors with the number
;               of elements equal to the number of trees in the
;               sequence of pruned subtrees of the tree cs. 
;               The vector seq.lnumber contains the numbers of leaves
;               in the sequence of the pruned subtrees.
;               The vector seq.alfa contains the values of the complexity
;               parameter alfa.
; -----------------------------------------------------------------------
; Notes     Pruning is described by Breiman, Friedman, Olshen, and Stone,
;           Classification and Regression Trees, 1984, Wadsworth,
;           pages 63, 284. 
; -----------------------------------------------------------------------
; Example      ; loads the library xclust
;              library ("xclust")
; ;let us generate a tree by cartsplit procedure
; x1=#(0,0,0,0,1,1,1,1,1,2)
; x2=#(0,0,0,0,0,0,0,1,1,1)
; x=x1~x2
; y=#(0,0,0,0,100,100,100,120,120,120)
; cs=cartsplit(x,y,#(0,1))
; cs
; seq=pruneseq(cs)
; seq
; -----------------------------------------------------------------------
; Result  
; Content of object cs.val.split0
; [1,] 0 
; [2,] 1,2 
; Content of object cs.val.split1
; [1,] NaN 
; Content of object cs.val.split2
; [1,] 0 
; Content of object cs.val.split3
; [1,] NaN 
; Content of object cs.val.split4
; [1,] NaN 
; Content of object cs.vec
; [1,] 1.000000 
; [2,] NaN 
; [3,] 2.000000 
; [4,] NaN 
; [5,] NaN 
; Content of object cs.mean
; [1,] 66.000000 
; [2,] 0.000000 
; [3,] 110.000000 
; [4,] 100.000000 
; [5,] 120.000000 
; Content of object cs.var
; [1,] 29640.000000 
; [2,] 0.000000 
; [3,] 600.000000 
; [4,] 0.000000 
; [5,] 0.000000 
; Content of object cs.nelem
; [1,] 10.000000 
; [2,] 4.000000 
; [3,] 6.000000 
; [4,] 3.000000 
; [5,] 3.000000 
; 
; Contents of seq.lnumber
; [1,] 3.000000 
; [2,] 2.000000 
; [3,] 1.000000 
; Contents of seq.alfa
; [1,] 0.000000 
; [2,] 60.000000 
; [3,] 2904.000000      
; -----------------------------------------------------------------------
; Author       Jussi Klemela , 980323         
; -----------------------------------------------------------------------
lnum=leafnum(tree,1)
tulos=matrix(lnum)
ntulos=tulos
tulos[1]=0
loppu=1
tr=init(tree)
curlnum=leafnum(tr,1)
ntulos[1]=curlnum
i=2
while (curlnum > 1)
      g=gform(tr)
      tmin=omaind(g)
      tulos[i]=g[tmin] 
      loppu=loppu+1
      tr=maketr(tr,tmin)
      curlnum=leafnum(tr,1)
      ntulos[i]=curlnum
      i=i+1
endo
alfa=tulos[1:loppu]
lnumber=ntulos[1:loppu]
y=list(lnumber,alfa)
endp
