proc(data)=randomsample(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istadata
; -----------------------------------------------------------------------
; Macro        randomsample
; -----------------------------------------------------------------------
; Description  selects a random sample according approximatively to a 
;              specified percentage of the dataset using a uniform random 
;              generator. The exact percentage of extracted rows is given
;              in the output window.
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data=datain
  randomize(0)
  vstr=" approximativ percentage of rows"
  vs=100
  do
    v= readvalue(vstr, vs)  
  until((v<=100)&&(v>0))
  v=v/100
  w=(uniform(rows(data.x))<v).*data.rowcase
  ;random sample
  selhead="Work with sample"
  selitem="Yes"|"no"
  sel=selectitem(selhead,selitem,"single")
  if(sel[1])
    data.randcase=w 
  endif
  if(sel[2])
    data.randcase=1*matrix(rows(data.x)) 
  endif
  s=(sum(data.randcase)/sum(data.rowcase))*100
  str=string("percentage of rows: %0f" ,s)
  str
endp
