proc (r) = rank (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      sort order 
; -----------------------------------------------------------------
;  Keywords      order statistics, rank statistics
; -----------------------------------------------------------------
;   Macro        rank
; -----------------------------------------------------------------
;   Description  Computes the rank vector of a given vector.
; -----------------------------------------------------------------
;   Usage        r = rank (x)
;   Input
;     Parameter  x  
;     Definition n vector
;   Output
;     Parameter  r
;     Definition n vector consisting of the ranks
; -----------------------------------------------------------------
;   Notes        If observations are equal, midranks are computed.
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = #(4,1,6,5,4)
;             rank (x)
; -----------------------------------------------------------------
;   Result
;             Contents of r
;             [1,]   2.5 
;             [2,]     1 
;             [3,]     5 
;             [4,]     4 
;             [5,]   2.5 
; -----------------------------------------------------------------
;   Author    TTK, 961125
; -----------------------------------------------------------------

  i  = 1:rows (x)
  o  = sort (x~i)[,2]
  r  = sort (o~i)[,2]
  i2 = sort (x~r, 1|-2)[,2]
  r  = 0.5*(i+i2)[r]



endp

