proc(z)=readcsvm(filename,separators)
; ---------------------------------------------------------------------
; Library     xplore
; ---------------------------------------------------------------------
; See_also    readcsv, read, write, readm, readascii
; ---------------------------------------------------------------------
; Macro       readcsvm
; ---------------------------------------------------------------------
; Description readcsvm reads mixed data from the csv file
; ---------------------------------------------------------------------
; Usage       z=readcsvm(filename{,separators})
; Input
; Parameter   filename
; Definition  name of file
; Parameter   separators
; Definition  string that contains the data separator in the file (default=";")
; Output
; Parameter   z.type
; Definition  (p+q) vector types of columns in file
; Parameter   z.double
; Definition  n x p matrix numerical vectors
; Parameter   z.text
; Definition  n x q matrix text vectors
; ---------------------------------------------------------------------
; Notes       If you read mixed data from a file the original
;             position of the vector in the file gets lost.
;             Thus you will receive 3 matrices which will
;             contain the vectors of one type. It is ensured that,
;             e.g. z.double[,1] was in the file before z.double[,2].
;             The last parameter z.type
;             contains the recognized type t of the corresponding vector
;             in the file (0 represents number, 1 text vector).
;             Note that  even if there is only one text element in some column
;             (other elements in this column are numbers) this column will
;             be represented as a text column. The signs " " or "." are also
;             represented as text.
;             File "example.csv" contains:
;               "hallo;5,4;john"
;               ";4,6; "
;               "hi;;george"
; ---------------------------------------------------------------------
; Example     library("xplore")
;             readcsvm("example.csv")
; ---------------------------------------------------------------------
; Result      Contents of out.type
;
;             [1,]        1
;             [2,]        0
;             [3,]        1
;
;             Contents of out.double
;
;             [1,]      5.4
;             [2,]      4.6
;             [3,]     +NAN
;
;             Contents of out.text
;
;             [1,] "hallo" "john"
;             [2,] "" " "
;             [3,] "hi" "george"
; ---------------------------------------------------------------------
; Author MB 000831
; ---------------------------------------------------------------------
;separator control
  if (exist("separators")<>2)
    separators = ";"
  endif
  {data20,type20}=readascii(filename,"\n")
;remove all new line signs (this implies also ignoring all empty lines)
  data=paf(data20,type20<>20)
;extracting the elements
  i=1
  datael=(strtok(data[i],separators))
  length=dim(datael)
  do
    i=i+1
    datatmp=strtok(data[i],separators)
    error(dim(datatmp)<>length,"readcsv:The lines with unequal length")
    datael=datael|datatmp
  until(i==dim(data))
;constructing the type vector
  i=0
  stringvec=0*matrix(dim(datael),1)
  do
    i=i+1
    tmp=datael[i]
    if ((atof(tmp)==NaN)&&(strlen(tmp)<>0));string
      stringvec[i]=1
    endif
  until(i==dim(datael))
  datatmp=reshape(datael,#(length,(dim(datael)/length),1))'
  stringid=sum(reshape(stringvec,#(length,(dim(datael)/length),1))')>0
  datatmp=reshape(datael,#(length,(dim(datael)/length),1))'
  text=(paf(datatmp',stringid'))'
  double=(atof(paf(replace(datatmp,"",".")',!(stringid'))))'
  type=stringid'
  z=list(type,double,text)
endp

