proc(rel)=relationchi2(x, colname, opt)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     relation relationcont relationcorrcont relationrank 
;              relationcorr
; -----------------------------------------------------------------------
; Macro        relationchi2
; -----------------------------------------------------------------------
; Description  Computes the Chi^2 coefficients for discrete data.
; ----------------------------------------------------------------------
;   Notes      To compute the chi^2 coefficient non-interactively you 
;              need to set opt = "automatic". In the interactive mode
;              you will get a menu sorted after the largest coefficients.
;              If you click on the coefficient you will get the crosstable 
;              of the corresponding variables.
;
; -----------------------------------------------------------------------
; Usage        rel = relchi2 (x {, colname {, opt})
; Input
;   Parameter  x 
;   Definition n x p      variables
;   Parameter  colname
;   Definition n x p      variable names
;   Parameter  opt 
;   Definition q x 1      text vector of optional parameters
; Output
;   Parameter  rel.r      
;   Definition p x p      matrix of chi^2 values
;   Parameter  rel.pval   
;   Definition p x p      significance level of chi^2 statistics
; -----------------------------------------------------------------------
; Example      ; loads the library stats
;              library("stats")   
;              ; read swiss banknote data
;              ; actually these data are continuous, but the first
;              ; three variables have approx. 20 realizations
;              x = read ("bank2")
;              ; compute the chi^2 statistic and its pvalues 
;              ; automatically
;              colname = string ("X%0.f", 1:cols(x))
;              relationchi2 (x, colname, "automatic")
; -----------------------------------------------------------------------
; Result  
; Contents of rel.r
; [1,]     4000   340.93   440.24   1054.5   641.76   982.71 
; [2,]   340.93     3200   472.66   810.69   570.29   709.79 
; [3,]   440.24   472.66     3600   937.03   596.87   779.53 
; [4,]   1054.5   810.69   937.03     9800   1793.3   2043.2 
; [5,]   641.76   570.29   596.87   1793.3     6800   1608.6 
; [6,]   982.71   709.79   779.53   2043.2   1608.6     8200 
;
; Contents of rel.pval
; [1,]        0  0.20152  0.0024184  0.048822     +NAN  7.3697e-05 
; [2,]  0.20152        0  3.8681e-11   0.2472  0.21048  0.071514 
; [3,]  0.0024184  3.8681e-11        0  0.096837     +NAN   0.1404 
; [4,]  0.048822   0.2472  0.096837        0  0.015248  0.29226 
; [5,]     +NAN  0.21048     +NAN  0.015248        0  5.1065e-05 
; [6,]  7.3697e-05  0.071514   0.1404  0.29226  5.1065e-05        0 
; -----------------------------------------------------------------------
; Author       Sigbert Klinke 970820
; ----------------------------------------------------------------------
  optgiven  = (exist("opt")==2)

  colnamegiven = (exist("colname")==2) 
  if (colnamegiven)
    colnamegiven = (rows(colname)==cols(x))
  endif
  if (!colnamegiven)
    colname = string ("X%.0f", 1:cols(x))
  endif

  p = cols(x)
  i = 0
  r = -1.*matrix(p,p)
  pval = -1.*matrix(p,p)
  while (i<p)
    i = i+1
    j = 0
    while (j<i)
      j = j+1
      {x1, x2, t} = table2(x[,i]~x[,j])
      e = sum(t).*sum(t,2)/rows(x)
      chi2 = (t-e)^2/e
      r[i,j] = sum(sum(chi2,2))
      r[j,i] = r[i,j]
      pval[i,j] = 1-cdfc(r[i,j], (rows(t)-1).*(cols(t)-1)) 
      pval[j,i] = pval[i,j]
    endo
  endo
  automatic = 0
  if (optgiven)
    automatic = sum(opt=="automatic")
  endif
  if (automatic==0)
    vr = vec(r)~grid(#(1,1), #(1,1), #(p,p))
    vr = sort(abs(vr[,1])~vr, -1)
    vr = vr[p+1:rows(vr)]
    vr = paf(vr, (1:rows(vr))%2)
    selhead = "Chi^2"
    vrp = 0
    sel = 1
    while (sum(sel))
      if (vrp==0)
        if (rows(vr)>15) 
          selitem = string ("%7.3f", vr[1:15,2])|"Next"
          selop   = (1:15)|-1
        else
          selitem = string ("%7.3f", vr[1:rows(vr),2])
          selop   = 1:rows(vr)
        endif
      else
        if ((vrp*15+15)<rows(vr))
          selitem = string ("%7.3f", vr[vrp*15+1:vrp*15+15,2])|"Back"|"Next"
          selop   = (vrp*15+1:vrp*15+15)|-2|-1
        else
          selitem = string ("%7.3f", vr[vrp*15+1:rows(vr),2])|"Back"
          selop   = (vrp*15+1:rows(vr))|-2
        endif
      endif
      sel = selectitem(selhead, selitem, "single")
      if (sum(sel))
        ii = paf (1:rows(sel), sel)
        i  = selop[ii]
        if (i==-1)
          if (vrp*15+16<rows(vr))
            vrp = vrp+1
          endif
        endif
        if (i==-2)
          if (vrp)
            vrp = vrp-1
          endif
        endif
        if (i>0)
          rdt = colname[vr[i,3]|vr[i,4]] 
          crosstable(x[,vr[i,3]]~x[,vr[i,4]], rdt)
        endif
      endif
    endo
  endif  
  rel = list (r, pval)
endp


