proc(rel)=relationcorr(x, colname, opt)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     relation relationchi2 relationcont relationcorrcont
;              relationrank
; -----------------------------------------------------------------------
; Macro        relationcorr
; -----------------------------------------------------------------------
; Description  Computes the bravais-pearson correlation for metric
;              data.
; ----------------------------------------------------------------------
;   Notes      To compute the correlation coefficient 
;              non-interactively you need to set opt = "automatic". 
;              In the interactive mode
;              you will get a menu sorted after the largest coefficients.
;              If you click on the coefficient you will get a plot 
;              of the corresponding variables.
; -----------------------------------------------------------------------
; Usage        rel = relationcorr (x {, colname {, opt})
; Input
;   Parameter  x 
;   Definition n x p      variables
;   Parameter  colname
;   Definition p x 1      text vector of names of x variables
;   Parameter  opt 
;   Definition q x 1      text vector of optional parameters
; Output
;   Parameter  rel.r      
;   Definition p x p      matrix of correlation coefficients
;   Parameter  rel.pval   
;   Definition p x p      pvalue of t-statistic (r=0)
; -----------------------------------------------------------------------
; Example      ; loads the library stats
;              library("stats")   
;              ; read swiss banknote data
;              x = read ("bank2")
;              ; compute the correlation coefficients
;              colname = string ("X%0.f", 1:cols(x))
;              relationcorr (x, colname, "automatic")
; -----------------------------------------------------------------------
; Result   Contents of rel.r;
;          [1,]        1  0.23129  0.15176  -0.1898 -0.061321   0.1943 
;          [2,]  0.23129        1  0.74326  0.41378  0.36235 -0.50323 
;          [3,]  0.15176  0.74326        1  0.48676  0.40067 -0.51648 
;          [4,]  -0.1898  0.41378  0.48676        1  0.14185 -0.62298 
;          [5,] -0.061321  0.36235  0.40067  0.14185        1 -0.59404 
;          [6,]   0.1943 -0.50323 -0.51648 -0.62298 -0.59404        1 
;
;          Contents of rel.pval;
;          [1,]        0  0.00098331  0.031935  0.0071053  0.38834  0.0058347 
;          [2,]  0.00098331        0        0  1.1275e-09  1.3454e-07  3.0864e-14 
;          [3,]  0.031935        0        0  2.7089e-13  4.1282e-09  4.885e-15 
;          [4,]  0.0071053  1.1275e-09  2.7089e-13        0  0.045109        0 
;          [5,]  0.38834  1.3454e-07  4.1282e-09  0.045109        0        0 
;          [6,]  0.0058347  3.0864e-14  4.885e-15        0        0        0 
; -----------------------------------------------------------------------
; Author       Sigbert Klinke 970820
; ----------------------------------------------------------------------
  colnamegiven = (exist("colname")==2) 
  if (colnamegiven)
    colnamegiven = (rows(colname)==cols(x))
  endif
  if (!colnamegiven)
    colname = string ("X%.0f", 1:cols(x))
  endif

  p = cols(x)
  r = corr(x)
  pval = 2-2.*cdft (abs(r).*sqrt(rows(x)-2)./sqrt(1-r^2), rows(x)-2)
  i = 0
  while (i<p)
    i = i+1
    pval[i,i] = 0
  endo
  optgiven  = (exist("opt")==2)
  automatic = 0
  if (optgiven)
    automatic = sum(opt=="automatic")
  endif
  if (automatic==0)
    vr = vec(r)~grid(#(1,1), #(1,1), #(p,p))
    vr = sort(abs(vr[,1])~vr, -1)
    vr = vr[p+1:rows(vr)]
    vr = paf(vr, (1:rows(vr))%2)
    selhead = "Bravais-Pearson"
    vrp = 0
    sel = 1
    while (sum(sel))
      if (vrp==0)
        if (rows(vr)>15) 
          selitem = string ("%7.3f", vr[1:15,2])|"Next"
          selop   = (1:15)|-1
        else
          selitem = string ("%7.3f", vr[1:rows(vr),2])
          selop   = 1:rows(vr)
        endif
      else
        if ((vrp*15+15)<rows(vr))
          selitem = string ("%7.3f", vr[vrp*15+1:vrp*15+15,2])|"Back"|"Next"
          selop   = (vrp*15+1:vrp*15+15)|-2|-1
        else
          selitem = string ("%7.3f", vr[vrp*15+1:rows(vr),2])|"Back"
          selop   = (vrp*15+1:rows(vr))|-2
        endif
      endif
      sel = selectitem(selhead, selitem, "single")
      if (sum(sel))
        ii = paf (1:rows(sel), sel)
        i  = selop[ii]
        if (i==-1)
          if (vrp*15+16<rows(vr))
            vrp = vrp+1
          endif
        endif
        if (i==-2)
          if (vrp)
            vrp = vrp-1
          endif
        endif
        if (i>0)
          relationdisp = createdisplay(1, 1)
          show (relationdisp, 1, 1, x[,vr[i,3]]~x[,vr[i,4]])
          rdt = string ("%s-%s : ", colname[vr[i,3]], colname[vr[i,4]]) + selitem[ii] 
          setgopt (relationdisp, 1, 1, "title", rdt)
        endif
      endif
    endo
  endif  
  rel = list(r, pval)
endp
