proc()= resclass(w, u, x, y, t)         
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        resclass 
; -----------------------------------------------------------------------
; Description  shows the residuals in case of the classification
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  if (cols(w).>3)         
    wb = w[,1:2]~w[,4]         
  else         
    wb = w         
  endif         
  yb = nnfunc(wb, u, x)         
  if (cols(y).>1) 
    "More than one output unit"        
    ib = maxind(yb,2).<>maxind(y,2)         
    err = NaN~(sum(ib)./rows(ib))         
    p = max(t)         
    i = 0         
    while (i.<=p)         
      it  = paf(ib, t.=i)         
      err = err|(i~(sum(it)./rows(it)))         
      i = i+1         
    endo       
  else       
    "One output unit"        
    tb = grid(0.1, 0.1, 9)       
    err = NaN~tb'       
    s = ((yb.>tb') .<> y)     
    err = err|(NaN~mean(s))       
    p = max(t)       
    i = 0       
    while (i.<=p)       
      st  = paf(s, t.=i)       
      err = err|(i~mean(st))       
      i = i+1         
    endo          
    err = trans(err)         
  endif         
;  errdisp = createdisplay (1,1)
;  edit (err)
   err
;  show (errdisp, 1, 1, err)          
endp          
