proc(hls)=rgb2hls(rgb)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     hls2rgb
; -----------------------------------------------------------------------
; Macro        rgb2hls
; -----------------------------------------------------------------------
; Description  Generates HLS-colors from the RGB color model.
; -----------------------------------------------------------------------
; Usage        hls = rgb2hls (rgb)
; Input
;   Parameter  rgb
;   Definition n x 3      array
; Output
;   Parameter  hls
;   Definition n x 3      array
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              rgb = (0:255).*matrix(256,3)
;              hls = rgb2hls (rgb)
;              hls
; -----------------------------------------------------------------------
; Result       computes the HLS colors from white-gray-black
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  v = dim(rgb)
  error (v[2]<>3, "hls2rgb : 3 columns expected")
  mi = min(rgb,2)
  ma = max(rgb,2)
  l  = (ma+mi)./512
  d  = ma-mi
  s  = (l.<=0.5).*d./(ma+mi)
  s  = s + (l.>0.5).*d./(2-ma-mi)
  ma = maxind(rgb,2)-1
  h  = 2.*ma+(ma.=0).*(rgb[,2]-rgb[,3])./d
  h  = h+(ma.=1).*(rgb[,3]-rgb[,1])./d
  h  = h+(ma.=2).*(rgb[,1]-rgb[,2])./d
  h  = h+(h.<0).*6
  v  = 1-(abs(h)<Inf)
  if (sum(v))
    i  = paf(1:rows(h), 1-(abs(h)<Inf))
    h[i] = 0.*matrix(rows(i))
  endif
  hls = (60.*h)~l~s
endp