proc(b,ctrl) = rlsbnorm(e,Sigt,H,Q,N,eps,itmax)

; -----------------------------------------------------------------
; Library        kalman
; -----------------------------------------------------------------
;  See_also      rlsfil
; -----------------------------------------------------------------
;   Macro        rlsbnorm, calibrLS
; -----------------------------------------------------------------
;   Description  Auxiliary routine for rlsfil: 
;                solves E [ |X-MYw_b(MY)|^2]=(1+e)E [ |X-MY|^2]
;                - if possible - by MC-integration
;                for X ~ N_n(0,Sigt), v ~ N_m(0,Q) indep.
;
;                M=Sigt H'(Q+HSigt H')^{-1}
;
;                Y=HX+v, w_b(x)=min(1,b/|x|)
; -----------------------------------------------------------------
;   Keywords     robust Kalman filter, rLS
; -----------------------------------------------------------------
;   Usage          {b,ctrl}=rlsbnorm(e,Sigt,H,Q,N,eps,itmax)
;   Input
;     Parameter   e  
;     Definition     numeric; efficiency loss to attain;
;     Parameter   Sigt    
;     Definition      n x n covariance matrix of the initial state
;     Parameter   H    
;     Definition      m x n matrix
;     Parameter   Q
;     Definition      m x m variance-covariance matrix 
;     Parameter    N
;     Definition      integer; MC-sample size
;     Parameter    eps
;     Definition      numeric; exactitude
;     Parameter    itmax
;     Definition      integer; maximal number of iterations
; Output                                                           
;     Parameter   b
;     Definition  numeric clipping height achieving e as rel. effiency loss
;     Parameter   ctrl  
;     Definition  integer; 1 if error occurs 0 else
; -----------------------------------------------------------------
; Notes
;     Not to be used outside of rlsfil!
; -----------------------------------------------------------------
;   Author    P.Ruckdeschel 991010 
; -----------------------------------------------------------------
;   Example   to be looked up in rlsfil
; -----------------------------------------------------------------
  
  
  n=rows(Sigt)
  m=rows(Q)
  M=(Sigt*H')*ginv((H*(Sigt*H'))+Q)
  Sigts=svd(Sigt)
  Qs=svd(Q)
  Sigtw=Sigts.u*(sqrt(Sigts.l).*Sigts.v')
  Qw=Qs.u*(sqrt(Qs.l).*Qs.v')
  X=Sigtw*normal(n,N)
  MY=M*(Qw*normal(m,N)+H*X)
  trSt=sum(unit(n).*ginv(ginv(Sigt)+ginv(H'*(Q*H))))

  i=0
  bl=0
  br=3*(max(Sigts.l)+max(Qs.l))^.5
  
  db=br/2
  
 intg=(X-MY)^2
 trSts= sum(intg,1)'
 trSts=mean(trSts)
 
 while ((db>eps) && (i<itmax))  
    
    b=(bl+br)/2
    
    norm=sqrt(sum(MY^2,1))
    norm1=(norm<b) .* b+(norm>=b).*norm ; necessary to avoid division by 0
    norm=(norm>=b).*b/norm1+(norm<b) ; norm is a weight function, =1 if |MY|<b,  =b/|MY| else   
    intg=(X-MY.*norm)^2
    integral= sum(intg,1)'
    integral=mean(integral)
    if ((integral/trSts-1)>e)
       bl=b
    else
       br=b
    endif
    db=br-bl
    i = i + 1 
  endo
ctrl=(db>eps)
endp
