
proc (y) = rqua(x)

; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     repa rtri rtrian runi genvub
; -----------------------------------------------------------------
;   Macro       rqua
; -----------------------------------------------------------------
;   Description  rqua computes the multivariate radial symmetric
;                quartic kernel
;                                       
; -----------------------------------------------------------------
;   Usage        y = rqua(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = rqua(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author   Sigbert Klinke, Lijian Yang, 951117   
; -----------------------------------------------------------------
  d  = cols(x)  
  error (d.>15, "rqua : Dimension too large (>15)")
  wd = getglobal("vub")[d]
  r  = sum(x^2,2)
  y  = prod(aseq(d, 3, 2))./(8.*wd).*((1-r).^2).*(r.<1) 
endp 
;***********************************************************************       
