
proc (y) = rtri(x)
 
; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     repa rqua rtrian runi genvub
; -----------------------------------------------------------------
;   Macro       rtri
; -----------------------------------------------------------------
;   Description  rtri computes the multivariate radial symmetric
;                triweight kernel
;                                       
; -----------------------------------------------------------------
;   Usage        y = rtri(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = rtri(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author   Sigbert Klinke, Lijian Yang, 951117   
; -----------------------------------------------------------------


  d  = cols(x)  
  error (d.>15, "rtri : Dimension too large (>15)")
  wd = getglobal("vub")[d]
  r  = sum(x^2,2)
  y  = prod(aseq(d, 3, 3))./(48.*wd).*((1-r).^3).*(r.<1) 

endp 
