
proc (y) = runi(x)
 
; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     repa rqua rtrian rtri genvub
; -----------------------------------------------------------------
;   Macro       runi
; -----------------------------------------------------------------
;   Description  runi computes the multivariate radial symmetric
;                uniform kernel
;                                       
; -----------------------------------------------------------------
;   Usage        y = runi(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-2, 41, 0.1) 
;             y = runi(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author   Sigbert Klinke, Lijian Yang, 951117   
; -----------------------------------------------------------------


  
  d  = cols(x)  
  error (d.>15, "runi : Dimension too large (>15)")
  wd = getglobal("vub")[d]
  r  = sum(x^2,2)
  y  = (1./wd).*(r.<1) 

endp 
