proc()=dosalsa()

; -----------------------------------------------------------------------
; Library      salsa
; -----------------------------------------------------------------------
; Macro        salsa
; -----------------------------------------------------------------------
; Description  Routines from time series program TRAMO
; -----------------------------------------------------------------------
; Notes        Uses some data from the TRAMO-SEATS-Package to demonstrate
;              the TRAMO-Routines within XploRe.                      
; -----------------------------------------------------------------------
; Keywords     TRAMO-SEATS, SALSA, seasonal adjustment
; -----------------------------------------------------------------------
; Usage        dosalsa()
; Input     
; Output       Linearized (preadjusted) series, forecasts,
;              white noise, autocorrelations    
; -----------------------------------------------------------------------
; Example           
; -----------------------------------------------------------------------
; Result 
; -----------------------------------------------------------------------
; Author       Andreas Ruppin
; -----------------------------------------------------------------------
  contmain=1
  while(contmain) 
    headmain = "BEISPILE AUS DEM TRAMO PAKET"  
    itemmain = "German GFCF (Build. & Constr.)"|"Ozone Level"| "Currency (Spain)"|"Spanish Indutrial Index"| "Break"    
    selmain = selectitem(headmain,itemmain)
    if(selmain[1])
      expl =read("inpexpl.dat")
      xplvar2 =read("inpdata.dat")
      lowlimit=1E04
      uplimit=11E04
      salsa(expl, xplvar2, lowlimit, uplimit)
    endif
    if(selmain[2])
      expl =read("ozono.par")
      xplvar2 =read("ozono.dat")
      lowlimit=0
      uplimit=10
      salsa(expl, xplvar2, lowlimit, uplimit)
    endif
    if(selmain[3])
      expl =read("currency.par")
      xplvar2 =read("currency.dat")
      lowlimit=8E04
      uplimit=9E06
      salsa(expl, xplvar2, lowlimit, uplimit)
    endif
    if(selmain[4])
      expl =read("ipi.par")
      xplvar2 =read("ipi.dat")
      lowlimit=80
      uplimit=120
      salsa(expl, xplvar2, lowlimit, uplimit)
    endif
    if(selmain[5])
      contmain=0
    endif
  endo
endp         
 
proc()=salsa(expl, xplvar2, lowlimit, uplimit)
  nrserie=expl[1]
  xplvar1 =#(expl[1], expl[2], expl[3], expl[4])
  original=xplvar2 
  xplvar3 =0*matrix(3)
  xplvar6 =0*matrix(expl[1])
  xplvar7 =0*matrix(expl[1])
  xplvar9 =0*matrix(64)
  xplvar10 =0*matrix(625)
  xplvar11 =0*matrix(64)
  xplvar12 =0*matrix(64)
  headline = "Do want to change parameters or use default values?"
  item = "change parameters" | "default values"
  k1=#( 4, 0, 1, 1, 1, 0, 0, 1, 1, -0.1, -0.1)
  k2=#( -0.1, -0.1, 0, 0, 0, 0)
  k3=#( 0, 0, 0.96, 0.88, 0.10, 0, 0.95, 0)
  k4=#( 0, 0, 2, 1, 1e-04, 1, 0.97, 36, 24, 2, 0, 1)
  k5=#( 0, 0, 1) 
  k6=#( 2, 1)
  k7=#( 3.5, 1, 0.14286, 0.7, 0, 2, 1, 106)
  k8=#( 0, 8, 0, 1, 0, 0, 0.1, 0)
  k9=#( 0, 0, 0, 0, 0, 0, 0)   
  k10=#(0, 0, 1.0, 0.98, 25, 0, 1, 2)
  k11=#(1, 0.5, 0, 1.5, 0, 3, 0, -0.4, 0.5)    
  sel = selectitem(headline,item)
  if(sel[1])
    headline2 = "What kind of parameters do you wish to change?"
    item2 = "ARIMA model parameters(1)"|"ARIMA model parameters(2)"|"Automatic model identification"|"Estimation"|"Forecasting"|"Missing observations"|"Outliers"|"Regression(1)"|"Regression(2)"|"Others"|"Seats parameter" 
    cont=1
    while(cont)
    i2 = selectitem(headline2,item2)
    if(i2[1])
      values1 = "MQ = "|"LAM ="|"IMEAN ="|"D ="|"BD ="|"P ="|"BP ="|"Q ="|"BQ ="|"TH ="|"BTH ="
      defaults1 =12    |  0    |  1      | 1   | 1    |  0  |  0   |  1  |  1   | -0.1 |-0.1  
      k1 = readvalue(values1,defaults1)      
      k1 
    endif    
    if(i2[2])
      values2 = "PHI = "|"BPHI ="|"JPR ="|"JPS ="|" JQR="|"JQS ="
      defaults2 = -0.1  | -0.1   |  0    |   0   |  0    |  0     
      k2 = readvalue(values2,defaults2)      
      k2 
    endif     
   if(i2[3])
      values3 = "INIC = "|"IDIF ="|"UB1 ="|"UB2 ="|"CANCEL ="|"IMVX ="|"PCR ="|"IFAL"
      defaults3 =  0     |  0     |0.96   |  0.88 |  0.10    |  0     | 0.95  |  0  
      k3 = readvalue(values3,defaults3)      
      k3 
    endif    
    if(i2[4])
      values4 = "INCON = "|"INIT ="|"IFILT ="|"IDENSC ="|"TOL ="|"ICONCE ="|"UBP ="|"M ="|"IQM ="|"IROOT ="|"IGRBAR ="|"TSIG ="
      defaults4 =  0      |  0     |   2     |     1    | 1e-04 |    1     | 0.97  |  36 |  24   |    2    |    0     |  1
      k4 = readvalue(values4,defaults4)      
      k4  
    endif  
    if(i2[5])
      values5 = "NBACK = "|"NPRED ="|"LOGN ="
      defaults5 =   0      |   0     |   1    
      k5 = readvalue(values5,defaults5)      
      k5  
    endif    
    if(i2[6])
      values6 = "INTERP = "|"ICDET ="
      defaults6 =   1      |   1         
      k6 = readvalue(values6,defaults6)      
      k6    
    endif  
    if(i2[7])
      values7 = "VA = "|"IATIP ="|"PC =" |"DELTATC ="|"ISTDV ="|"AIO ="|"INT1 ="|"INT2 ="
      defaults7 =  3.5 |  1      |0.14286|   0.7     |    0    |  2    |  1     |   0    
      k7 = readvalue(values7,defaults7)      
      k7  
    endif  
    if(i2[8])
      values8 = "IEAST = "|"IDUR ="|"ITRAD ="|"INTD1 ="|"INTD2 ="|"IREG ="|"RG ="|"IUSER ="
      defaults8 =  0      |  8     |   0     |    1    |   0     |  0     | 0.1  |   0     
      k8 = readvalue(values8, defaults8)      
      k8   
    endif  
    if(i2[9])
      values9 ="NSER ="|"ILONG ="|"ISEQ ="|"DELTA ="|"DELTAS ="|"ID1DS ="|"REGEFF ="
      defaults9 = 0    |    0    |   0    |  0      |   0      |   0     |   0
      k9 = readvalue(values9, defaults9)      
      k9   
    endif  
    if(i2[10])
      values10 ="PG ="|"SEATS ="|"UR ="|"XL ="|"QMAX ="|"DVA ="|"RSA ="|"ITER ="
      defaults10 = 0  |  0      | 1.0  | 0.98 |  50    |  0    |  0    |  0
      k10 = readvalue(values10, defaults10)      
      k10   
    endif  
    if(i2[11])
      values11 ="BIAS ="|"MAXBIAS ="|"NOADMISS ="|"HS ="|"CRMEAN ="|"EPSPHI ="|"SMTR ="|"THTR ="|"RMOD ="
      defaults11 = 1    |  0.5      |   0        | 1.5  |  0       |  3       |
  0     |  -0.4  |  0.5
      k11 = readvalue(values11, defaults11)      
      k11   
    endif  
    cont=sum(i2)
  endo
  endif
  if(sel[2])
  endif  
  
  xplvar8=k1|k2|k3|k4|k5|k6|k7|k8|k9|k10|k11
  param = list(xplvar1,xplvar2,xplvar3,xplvar6,xplvar7,xplvar8,xplvar9,xplvar10,xplvar11,xplvar12)  
  byrow= 0| 0| 0|0|0|0|0|0|0|0
  type =-8| 8|-8|8|8|8|8|8|8|8
  opt=list(type,byrow)
  tramoha=dlopen("tramo.dll")
  dlcallex(tramoha,"_MAIN__", param, opt)  
  
  interpol  =param.xplvar6
  linear    =param.xplvar7
  nrwn      =param.xplvar3[1]
  
  whitenoise=param.xplvar10
  ind=whitenoise<>0
  whitenoise=paf(whitenoise, ind)
  nrwn=dim(whitenoise)

  autocor= param.xplvar11
  ind=autocor<>0
  autocor=paf(autocor, ind)
  nrcor=dim(autocor) 

  parauto= param.xplvar12
  ind=parauto<>0
  parauto=paf(parauto, ind)
  nrpcor=dim(parauto)  
  
  forecast=param.xplvar9
  ind=forecast<>0
  forecast=paf(forecast, ind)
  nrforc=dim(forecast) 
 
  bild1=createdisplay(1,1)
  pm=(1:nrserie)'
  i=1
  while(i < nrserie)
    if(original[i] == -99999)
      pm[1,i]=0
    endif
    i=i+1
  endo
  graf1=(1:nrserie)~original
  setmaskl(graf1,pm,4,1,2)
  setmaskp(graf1,4,3,4)
  show(bild1,1,1,graf1)
  setgopt(bild1,1,1,"title","Original Serie","ylim",0|uplimit) 
  
  graf2=((1:nrserie) | (1:nrserie)) ~ (interpol | linear)
  bild2=createdisplay(1,1) 
  pm2=(1:nrserie)'
  pm2= pm2 |( ( (nrserie+1) : (2*nrserie))')    
  setmaskl(graf2, pm2,#(4,1) , 1, 2)
  color=4*matrix(nrserie) | 1*matrix(nrserie)
  sy=3*matrix(nrserie) |2*matrix(nrserie)
  setmaskp(graf2,color,sy,3)
  show(bild2,1,1,graf2)
  setgopt(bild2,1,1,"title","Interpolated (red) and Linearized (blue) Serie","ylim",0|uplimit) 
  contmain2=1
  while(contmain2)
    headline2 = "What do you want to see"
    item2 = "Forecasts"|"White noise"|"Autocorrelations"|"Partial Autocorrelations"|"Break"  
    sel2 = selectitem(headline2,item2)
    if(sel2[1])
      extended=original|forecast
      nrext=nrserie+nrforc
      pm=(1:nrext)'
      i=1
      while(i<=nrext)
        if(extended[i] == -99999)
          pm[1,i]=0
        endif
        i=i+1
      endo

      pm=(1:nrext)'
      i=1
      while(i < nrserie)
        if(original[i] == -99999)
          pm[1,i]=0
        endif
        i=i+1
      endo
      bild11=createdisplay(1,1)     
      graf11=(1:nrext)~extended
      color=4*matrix(nrserie) | 1*matrix(nrforc)
      orig=((1:nrserie) | (0*matrix(nrforc)))
      forc=((nrserie+1) : (nrserie + nrforc)) | (0*matrix(nrserie)) 
      setmaskl(graf11,(orig~forc)',#(4,1),1,2)
      setmaskp(graf11,color,3,4)
      show(bild11,1,1,graf11)
      setgopt(bild11,1,1,"title","Original Serie with forecasts","ylim",0|uplimit)    
    endif
    if(sel2[2])
      plot((1:nrwn)~whitenoise)
    endif
    if(sel2[3])
      plot((1:nrcor)~autocor)
    endif
    if(sel2[4])
      plot((1:nrpcor)~parauto)
    endif
    if(sel2[5])
      contmain2=0  
    endif
  endo
  dlclose(tramoha)
endp