proc(sel)=selectitemlist(selhead,selitem,length)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista selctitem
; -----------------------------------------------------------------------
; Macro        selectitemlist
; -----------------------------------------------------------------------
; Description  opens a self defined menu box to ask for a choice like
;              selectitem. For more than 15 variables a "forward" and a
;              "backward" option ist implemented. 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  c=rows(selitem)
  if((c<=length)||(getenv("os")=="windows"))
    sel=selectitem(selhead,selitem)
  else 
  sel=0*matrix(c)
  a=1
  ende = 0
  do
    e=min((a+length-1)|c)  
    switch
;
      case(e==rows(sel)) 
      selh=selectitem(selhead,selitem[a:e]|"backward") 
      sel[a:e] = selh[1:rows(selh)-1] 
      if (selh[rows(selh)]) 
        a=a-length
      else
        ende=1
      endif  
      break
;
    case(a==1) 
      selh=selectitem(selhead,selitem[a:e]|"forward") 
      ende=sum(selh).=0 
      sel[a:e] = selh[1:rows(selh)-1]
      if (selh[rows(selh)]) 
        a=a+length 
      else  
        ende=1
      endif  
      break
;
    default 
      selh=selectitem(selhead,selitem[a:e]|"backward"|"forward") 
      ende=sum(selh).=0
      sel[a:e] = selh[1:rows(selh)-2]
      if (selh[rows(selh)])
        a=a+length
      endif  
      if (selh[rows(selh)-1])
        a=a-length
      endif  
      ende=(selh[rows(selh)]+selh[rows(selh)-1]).=0 
      break
    endsw
   until(ende)
  endif
endp
