proc(covc)=sfcoeff(ord,di,tb,te,adj,typ,ytt)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  covres
; ----------------------------------------------------------------------
;   Macro	  sfcoeff
; ----------------------------------------------------------------------
;   Description   estimates standard errors of parameter estimates
; ----------------------------------------------------------------------
;   Usage         covc = sfcoeff(ord,di,tb,te,adj,typ,ytt)
;   Input 
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   di 
;     Definition     integer, dimension of time series
;     Parameter   tb 
;     Definition     integer, (time) begin
;     Parameter   te 
;     Definition     integer, (time) end 
;     Parameter   adj 
;     Definition     scalar, 1=if adjusted, 0=if not
;     Parameter   typ 
;     Definition     integer, describing the model type
;     Parameter   ytt 
;     Definition     vector, the transformed time series
;   Output
;     Parameter   covc
;     Definition     matrix 
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich 971212
; ---------------------------------------------------------------------- 
 if ((ord==0) && (adj==1))
   covc=0
 else
   covr=covres(ord,di,tb,te,adj,typ,ytt)
   zz=zmulz(ord,di,tb,te,adj,0,typ,ytt)
   covc=kron(xdiag(inv(zz)),xdiag(covr)')
   covc=reshape(covc^.5,#(di*ord+1-adj,di))'
endif
endp
