proc (s) = sign (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      abs
; -----------------------------------------------------------------
;   Keywords     sign
; -----------------------------------------------------------------
;   Macro        sign
; -----------------------------------------------------------------
;   Description  Computes the sign function (0, -1, 1)
;                for zeros, negative or positive values.
; -----------------------------------------------------------------
;   Usage        s = sign (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  s  
;     Definition array  containing signs for all values of x
; -----------------------------------------------------------------
;   Example   library("xplore")
;             randomize (0)
;             x = normal (2, 3) ~ (0|0)
;             sign (x)
; -----------------------------------------------------------------
;   Result
;             Contents of s
;             [1,]       -1        1       -1       0
;             [2,]       -1       -1        1       0
; -----------------------------------------------------------------
;   Author    TTK, 970617
; -----------------------------------------------------------------

  s = (x > 0) - (x < 0)
endp