proc () = spatialSPKRtest ()

topo = read ("topo.dat")


; Figure 14.1 VR
;
myres2 = SPKRsurfls(2, topo)
myres3 = SPKRsurfls(3, topo)
myres4 = SPKRsurfls(4, topo)
myres6 = SPKRsurfls(6, topo)
;
mygrid2 = SPKRtrmat(myres2, 0, 6.5, 0, 6.5, 30)
mygrid3 = SPKRtrmat(myres3, 0, 6.5, 0, 6.5, 30)
mygrid4 = SPKRtrmat(myres4, 0, 6.5, 0, 6.5, 30)
mygrid6 = SPKRtrmat(myres6, 0, 6.5, 0, 6.5, 30)
;
d = createdisplay (2, 2)
;
cont2 = SPKRmultcontours(d, 1, 1, mygrid2, 750, 975, 25)
topoxydat = topo[,1] ~ topo[,2]
setmaskp(topoxydat, 4, 5, 8)
adddata(d, 1, 1, topoxydat)
setheadline(d, 1, 1, "Degree = 2")
;
cont3 = SPKRmultcontours(d, 1, 2, mygrid3, 725, 900, 25)
adddata(d, 1, 2, topoxydat)
setheadline(d, 1, 2, "Degree = 3")
;
cont4 = SPKRmultcontours(d, 2, 1, mygrid4, 700, 975, 25)
adddata(d, 2, 1, topoxydat)
setheadline(d, 2, 1, "Degree = 4")
;
cont6 = SPKRmultcontours(d, 2, 2, mygrid6, 600, 1000, 25)
adddata(d, 2, 2, topoxydat)
setheadline(d, 2, 2, "Degree = 6")


; Figure 14.5 VR
;
myres2 = SPKRsurfls(2, topo)
mygres2 = SPKRsurfgls(2, 0, topo, 1000, 0.7, 0, 1)
;
mygrid2 = SPKRtrmat(myres2, 0, 6.5, 0, 6.5, 30)
myggrid2tr = SPKRtrmat(mygres2, 0, 6.5, 0, 6.5, 30)
myggrid2pr = SPKRprmat(mygres2, 0, 6.5, 0, 6.5, 50)
myggrid2se = SPKRsemat(mygres2, 0, 6.5, 0, 6.5, 30)
;
f = createdisplay (2, 2)
;
cont2 = SPKRmultcontours(f, 1, 1, mygrid2, 750, 975, 25)
topoxydat = topo[,1] ~ topo[,2]
setmaskp(topoxydat, 4, 5, 8)
adddata(f, 1, 1, topoxydat)
setheadline(f, 1, 1, "LS trend surface")
;
cont2tr = SPKRmultcontours(f, 1, 2, myggrid2tr, 750, 950, 25)
adddata(f, 1, 2, topoxydat)
setheadline(f, 1, 2, "GLS trend surface")
;
cont2pr = SPKRmultcontours(f, 2, 1, myggrid2pr, 700, 950, 25)
adddata(f, 2, 1, topoxydat)
setheadline(f, 2, 1, "Kriging prediction")
;
cont2se = SPKRmultcontours(f, 2, 2, myggrid2se, 20, 25, 5)
adddata(f, 2, 2, topoxydat)
setheadline(f, 2, 2, "Kriging s.e.")


; Figure 14.6 VR
;
myres2 = SPKRsurfls(2, topo)
corres = SPKRcorrelogram(myres2, 25)
;
e = createdisplay (1, 2)
;
linedat1 = #(0, 7)~#(-1, 1)
setmaskp (linedat1, 0, 0, 0)
;setmaskl (linedat1, #(1, 2)', 0, 0, 0)
show (e, 1, 1, linedat1)
;
linedat2 = #(0, 7)~#(0, 0)
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, #(1, 2)', 0, 1, 3)
adddata (e, 1, 1, linedat2)
;
xydat = corres.xpres ~ corres.ypres
setmaskp(xydat, 4, 5, 8)
adddata (e, 1, 1, xydat)
;
ddat = grid(0, 0.1, 71)
linedat3 = ddat ~ SPKRexpcov(ddat, 0.7, 0, 1)
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:70) ~ (2:71), 1, 1, 2)
adddata (e, 1, 1, linedat3)
setheadline(e, 1, 1, "Correlogram")
;
;
varres = SPKRvariogram(myres2, 25)
;
xydat = varres.xpres ~ varres.ypres
setmaskp(xydat, 4, 5, 8)
show (e, 1, 2, xydat)
setheadline(e, 1, 2, "Variogram")


; Figure 14.7 VR
;
mygres2 = SPKRsurfgls(2, 0, topo, 1000, 0.7, 0, 1)
corres = SPKRcorrelogram(mygres2, 25)
;
g = createdisplay (1, 2)
;
linedat1 = #(0, 7)~#(-1, 1)
setmaskp (linedat1, 0, 0, 0)
;setmaskl (linedat1, #(1, 2)', 0, 0, 0)
show (g, 1, 1, linedat1)
;
linedat2 = #(0, 7)~#(0, 0)
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, #(1, 2)', 0, 1, 2)
adddata (g, 1, 1, linedat2)
;
xydat = corres.xpres ~ corres.ypres
setmaskp(xydat, 4, 5, 8)
adddata (g, 1, 1, xydat)
;
ddat = grid(0, 0.1, 71)
linedat3 = ddat ~ SPKRexpcov(ddat, 0.7, 0, 1)
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:70) ~ (2:71), 1, 1, 2)
adddata (g, 1, 1, linedat3)
;
ddat = grid(0, 0.1, 71)
linedat4 = ddat ~ SPKRgaucov(ddat, 1.0, 0.3, 1)
setmaskp (linedat4, 0, 0, 0)
setmaskl (linedat4, (1:70) ~ (2:71), 3, 4, 2)
adddata (g, 1, 1, linedat4)
setheadline(g, 1, 1, "Correlogram (Fitted Data)")
;
; (right)
;
myres2 = SPKRsurfls(0, topo)
corres = SPKRcorrelogram(myres2, 25)
;
linedat1 = #(0, 7)~#(-1, 1)
setmaskp (linedat1, 0, 0, 0)
;setmaskl (linedat1, #(1, 2)', 0, 0, 0)
show (g, 1, 2, linedat1)
;
linedat2 = #(0, 7)~#(0, 0)
setmaskp (linedat2, 0, 0, 0)
setmaskl (linedat2, #(1, 2)', 0, 1, 2)
adddata (g, 1, 2, linedat2)
;
xydat = paf(corres.xpres ~ corres.ypres, abs(corres.ypres) <= 1.1)
setmaskp(xydat, 4, 5, 8)
adddata (g, 1, 2, xydat)
;
ddat = grid(0, 0.1, 71)
linedat3 = ddat ~ SPKRgaucov(ddat, 2.0, 0.05, 1)
setmaskp (linedat3, 0, 0, 0)
setmaskl (linedat3, (1:70) ~ (2:71), 1, 1, 2)
adddata (g, 1, 2, linedat3)
setheadline(g, 1, 2, "Correlogram (Raw Data)")



; Figure 14.8 VR
;
mygres2 = SPKRsurfgls(2, 1, topo, 1000, 1, 0.3, 1)
;
myggrid2pr = SPKRprmat(mygres2, 0, 6.5, 0, 6.5, 50)
myggrid2se = SPKRsemat(mygres2, 0, 6.5, 0, 6.5, 25)
;
h = createdisplay (2, 2)
;
cont2pr = SPKRmultcontours(h, 1, 1, myggrid2pr, 725, 950, 25)
topoxydat = topo[,1] ~ topo[,2]
setmaskp(topoxydat, 4, 5, 8)
adddata(h, 1, 1, topoxydat)
setheadline(h, 1, 1, "Kriging prediction")
;
cont2se = SPKRmultcontours(h, 1, 2, myggrid2se, 20, 25, 5)
adddata(h, 1, 2, topoxydat)
setheadline(h, 1, 2, "Kriging s.e.")
;
; (right)
;
mygres2 = SPKRsurfgls(0, 1, topo, 10000, 2, 0.05, 1)
;
myggrid2pr = SPKRprmat(mygres2, 0, 6.5, 0, 6.5, 50)
myggrid2se = SPKRsemat(mygres2, 0, 6.5, 0, 6.5, 25)
;
cont2pr = SPKRmultcontours(h, 2, 1, myggrid2pr, 725, 925, 25)
adddata(h, 2, 1, topoxydat)
setheadline(h, 2, 1, "Kriging prediction")
;
cont2se = SPKRmultcontours(h, 2, 2, myggrid2se, 15, 25, 5)
adddata(h, 2, 2, topoxydat)
setheadline(h, 2, 2, "Kriging s.e.")


ddat = grid(0, 0.1, 71)
SPKRsphercov(ddat, 2.0, 0.05, 1, 2)


"spatialSPKRtest successfull"

endp


