proc(specd) = spec(x,width,opt)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  fft, invfft, pgram 
; ----------------------------------------------------------------------
;   Macro	  spec
; ----------------------------------------------------------------------
;   Description   estimates and plots the spectral density
;                 of a time series
; ----------------------------------------------------------------------
;   Usage         specd = spec(x {,width {,opt}} )
;   Input 
;     Parameter   x 
;     Definition  vector
;     Parameter   width (optional)
;     Definition  scalar, 0 <= width <= (rows(x)/2)
;     Parameter   opt (optional)
;     Definition  integer; If opt=1 (Default) the spectral density 
;                 estimate is returned, otherwise the log spectral
;                 density estimate
;   Output
;     Parameter   specd
;     Definition  vector
; ----------------------------------------------------------------------
;   Example       library("times")
;                 randomize (0)
;                 x=genarma(0.9,0,normal(100))
;		              y=spec(x)
;                 y[1:5]
; ----------------------------------------------------------------------
;   Result    plots the estimated spectral density of a time series
;
;             Contents of _tmp
;             [1,]   21.845 
;             [2,]   21.249 
;             [3,]   20.079 
;             [4,]   18.803 
;             [5,]   17.186                
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970725
; ----------------------------------------------------------------------
  n=rows(x)
  if (exist(width)==0)
    width=floor(n/10)
  endif  
  if (exist(opt)==0)
    opt=1   
  endif  
  seri=pgram(x,1)
  n2=floor(n/2)
  ss=seri[n2-1:1]|0|seri|0|seri[n2-1:1]
  specd=matrix(n2,1)
  weight=parzen((-width:width)/n,9)
  weight=weight/sum(weight)
  j=1
  while(j<=n2)
    ww=weight.*ss[(n2+j-width):(n2+j+width)]
    specd[j]=sum(ww)
    j=j+1
  endo
  dspec=createdisplay(1,1)
  if(opt<>1)
     specd=log(specd)
  endif
  ind=1:n2
  w=setmask((ind/n)~specd, "line", "solid")
  show(dspec,1,1,w)
  setgopt(dspec,1,1,"xlabel","frequency","ylabel","density" )
endp
