proc (xyaug) = spfill(x,y, a, b, h, r)
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;  See_also      lpregest lpderest
; -----------------------------------------------------------------
;   Macro        spfill
; -----------------------------------------------------------------
;   Description  spfill fills places of sparsity with interpolated
;                observations to avoid the need of oversmoothing.        
; -----------------------------------------------------------------
;   Usage         xyaug = spfill(x,y, a, b, h, r)
;   Input
;     Parameter  x  
;     Definition n x 1 matrix
;     Parameter  y  
;     Definition n x 1 matrix
;     Parameter  a 
;     Definition scalar, lower limit for estimation 
;     Parameter  b 
;     Definition scalar, upper limit for estimation  
;     Parameter  h 
;     Definition scalar, bandwidth 
;     Parameter  r
;     Definition scalar, scaling factor     
;   Output
;     Parameter  xyaug  
;     Definition n x 2 matrix, is the augmented and sorted data 
; -----------------------------------------------------------------
;   Example   library("smoother")
;             n = 50
;             x = uniform(n) 
;             y = sin(2.*pi.*x) + 0.1.*normal(n)
;             a = -0.2 b = 1.2
;             h = 0.05 r = 2
;             xyaug = spfill(x,y,a,b,h,r)
;             estaug=lpregest(xyaug,h) 
;             t = createdisplay(1,1)                                      
;             show(t,1,1,x~y,xyaug,estaug)
; -----------------------------------------------------------------
;   Result    Computes and plots the local linear estimator using
;             the augmented data.   
; -----------------------------------------------------------------
;   Author    Berwin Turlach & Lijian Yang, 970610   
; -----------------------------------------------------------------
  dat = x~y
  dat = sort(dat,1)
  x = dat[,1]
  y = dat[,2]
  n = rows(x)
  diff = x[2:n,] - x[1:(n-1),]
  m = floor(r*diff)./(2*h)
  xaug = x
  yaug = y
 
  if( sum((m<2)) == (n-1)) 
    xyaug = dat
  else              // here the case of real gaps
  ind = paf((1:(n-1)), (m.>=2) )
  ngap = rows(ind)
  i = 1
  
  while (i<=ngap)
    xt = x[ ind[i], ] + (1:(m[ind[i],]-1))*diff[ind[i]]/m[ind[i],]
    yt = ((x[ ind[i]+1, ] - xt)./diff[ind[i],]).*y[ ind[i], ]
    yt = yt - ((x[ ind[i], ] - xt)./diff[ind[i],]).*y[ ind[i]+1, ]
    yaug = yaug|yt
    xaug = xaug|xt
    i = i + 1
  endo
     endif
   m = floor(r.*(x[1]-a)./h)
   if (m>1)
    xt = a + (1:(m-1))*(x[1]-a)/m
    yt = y[1].*matrix(m-1) 
    yaug = yaug|yt
    xaug = xaug|xt    
   endif
    m = floor(r.*(b-x[n-1])./h)
   if (m>1)
    xt = x[n-1] + (1:(m-1))*(b-x[n-1])/m
    yt = y[n-1].*matrix(m-1) 
    yaug = yaug|yt
    xaug = xaug|xt
   endif
xyaug = sort(xaug~yaug, 1)
endp
