proc(pv) = sptest(x, y, p, levels)
; -----------------------------------------------------------------
; Library        gam
; -----------------------------------------------------------------
;  See_also      intest, intestpl, gintest, gintestpl,backfit
; -----------------------------------------------------------------
;   Macro        sptest
; -----------------------------------------------------------------
;   Description   Additive component analysis in additive separable
;                 models using wavelet estimation. An additive component 
;                 can be tested against a given polynomial form with degree
;                 p, e.g. when p is set to zero we test for significant
;                 influence of that component.
;                 The procedure is presented in
;                     Haerdle, Sperlich, Spokoiny (2000)
;                 but implemented without the "t_{j,alpha}" correction.
; -----------------------------------------------------------------
;   Usage         pv = sptest(x,y,p{,levels})   
;   Input
;     Parameter   x  
;     Definition      n x p matrix , the observed explanatory variable
;                     where the discrete variables have to be placed 
;                     into the last (dis) columns 
;     Parameter   y 
;     Definition      n x 1 matrix , the observed response variable  
;     Parameter   p
;     Definition      scalar , the polynomial degree of the Hypothesis 
;     Parameter   levels
;     Definition      dis x 1 vector of integrers < 4, 
;                     wavelet levels for the components 
;                     of the discrete variables; max = 3
;   Output                                                           
;     Parameter   pv
;     Definition    p-value of the hypothesis
; -----------------------------------------------------------------
;   Example   library("gam")
;             n   = 100
;             randomize(1234)
;             x   = normal(n,3)
;             eps = normal(n,1) * sqrt(0.8)
;             y   = sin(2*x[,1]) + x[,2]^2 + 2*x[,3] +eps
;             p   = 1
;             pv = sptest(x,y,p)
; -----------------------------------------------------------------
;   Result   table of results
; -----------------------------------------------------------------
;   Author    Sperlich 000622
; -----------------------------------------------------------------
d   = cols(x) 
n   = rows(x)
dis = 0
jj = floor(log(n/(3*d))/log(2))
jn = jj*matrix(d) 
if (exist(levels)==1)
  error (max(levels)>3, "max(levels) has to be < 4") 
  if (jj<3)
     error (max(levels)>2, "max(levels) has to be < 3") 
  endif   
  levels = floor(levels)
  dis = rows(levels)
  hel = sum( (4^(levels)) )
  jj = floor(log(n/(3*d-dis) -hel )/log(2))   
  jn = (jj*matrix(d-dis))|levels 
endif
n   = rows(x)
nb = 249
/*  some auxiliary expressions for Haar basis  */
 j = 1
 mult = 1 
 subt = 0 
 do 
   mult = mult | (matrix(2^j,1) * 2^j)
   subt = subt | aseq(0,2^j,1) 
   j    = j+1 
 until (j>jj)
 
Tdet = matrix(jj+1,nb+1) *0.0
x  = (x.-min(x,1)) / (max(x,1).-min(x,1)) 
/* Construction of Haarbasis for nuisance directions */
 XDv = matrix(n,1)*0.0 
 j=2;
 do 
   tra = (mult'.* x[,j]) - subt' 
   XDt = ((0.5<tra) && (tra<=1))-((0<tra) && (tra<=0.5)) 
   XDt = x[,j]~XDt 
 if (jn[j,]==3)
   XDt = XDt[,1:16]
 endif
 if (jn[j,]==2);
   XDt = XDt[,1:8]
 endif
 if (jn[j,]==1);
   XDt = XDt[,1:4]
 endif
   lam = sqrt( sum(XDt^2) ) 
   lam = lam + (abs(lam)<0.001) 
   XDt = XDt / lam 
   XDv = XDv~XDt 
   j = j+1
 until (j>d)
 dim = cols(XDv) 
 XDv = XDv[,2:dim] 
 dim = dim-1 
/* Estimation procedure  1st dir.for all levels  */
yb = normal(n,nb) 
variv = matrix(nb,1) 
Tdetmax  = -1000
j1= jj 
do 
 j = 1
 mult1 = 1 
 subt1 = 0 
 do  
   mult1 = mult1 | (matrix(2^j,1) * 2^j)
   subt1 = subt1 | aseq(0,2^j,1) 
   j = j+1 
 until (j>j1)
 
  tra = (mult1'.* x[,1]) - subt1' 
  xd1 = ((0.5<tra) && (tra<=1))-((0<tra) && (tra<=0.5))
  xd1 = matrix(n,1)~x[,1]~xd1 
  lam1= sqrt( sum(xd1^2) ) 
  lam1= lam1+(abs(lam1)<0.001)
  lam1= lam1^(-1) 
  xd1 = lam1 .* xd1 
  if (dim>1)
    XD = xd1~XDv 
  else
    XD = xd1 
  endif
 dim1= cols(xd1) 

 WJT= ginv(XD'*XD)*XD' 
 bb = WJT * y 
if (j1 == jj)
 nrn  = n-sum(xdiag(WJT*XD))   
 vari = y - XD*bb 
 vari = vari'* vari 
 vari = vari / nrn 
endif
/*  test statistic */
  Wjtr = WJT[(dim1-2^(j1)+1):dim1,] 
  WWin = ginv((Wjtr*Wjtr')) 
  bbd  = bb[(dim1-2^(j1)+1):dim1,1] 
 if (rows(Wjtr)>1)
    tr  = floor( sum(xdiag(Wjtr'*WWin*Wjtr)) )
 else
    tr = floor( sum(WWin*Wjtr*Wjtr') )
 endif
Tdet[(j1+1),1] = ((bbd'*WWin*bbd)/vari -tr)/ sqrt(2*tr) 
ib = 1
do                     ; Monte Carlo
 bbb = WJT *yb[,ib] 
 bbd = bbb[(dim1-2^(j1)+1):dim1,1] 
 if (j1 == jn)
   varib = yb[,ib] - XD*bbb 
   varib = varib' * varib 
   variv[ib,1] = varib / nrn 
 endif
 Tdet[(j1+1),(1+ib)] = ((bbd'*WWin*bbd)/variv[ib,1] -tr)/sqrt(2*tr) 
 ib = ib+1
until (ib>nb)
j1 = j1-1
until (j1 < 0)
 Tstar  = max(Tdet) 
 pv = 1-mean((Tstar[1,1]>Tstar),2)
endp

