proc (xyline)=steps4plot(xy, xymin, xmax)   
; -----------------------------------------------------------------
; Library     hazreg
; -----------------------------------------------------------------
; Macro       steps4plot
; -----------------------------------------------------------------
; Description produces a matrix of points for plotting a left
;             continuous step function. 
; -----------------------------------------------------------------
; Usage       (xyline)=steps4plot(xy, xymin, xmax)
; Input
; Parameter   xy 
; Definition  n x 2 matrix, coordinates of the jump points sorted 
;             by the first column
; Parameter   xymin 
; Definition  1 x 2 matrix, coordinates of the starting point. 
;             Default is the first jump point. Its x coordinate is 
;             set to that of the first jump if specified as larger. 
; Parameter   xmax 
; Definition  scalar, x coordinate of the ending point Default is
;             by adding 1% of the x range to the last jump point.
;             Its x coordinate is set to that of the last first 
;             jump if specified as smaller. Y coordinate of the
;             ending point is always that of the last jump point. 
; Output
; Parameter   xyline  
; Definition  4*(n+1) x 2 matrix, the points to be connected into
;             step function.
; -----------------------------------------------------------------
; Author     Lijian Yang 20000213
; -----------------------------------------------------------------
  n=rows(xy)

  x = xy[,1]
  y = xy[,2]

if (exist(xymin)==0)
    xymin = xy[1,]
endif

if (xymin[1,1]>x[1])
    xymin[1,1]=x[1]
endif

if (exist(xmax)==0)
    xmax = x[n] + (x[n]-x[1])/100
endif

if (xmax<x[n])
    xmax=x[n]
endif

ymax = y[n]

xymax = xmax~ymax

xy = xymin|xy|xymax

xy1 = (xy[2:n+2,1])~(xy[1:n+1,2])

xyline = (xy[1:n+1,])|xy1|xy1|(xy[2:n+2,])
  
endp

