proc(d)=strucbru(b,covb,di,ord,adj,tb,te,t,covu,typ,ytt,outp)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      
; -----------------------------------------------------------------
;   Macro         strucbru
; -----------------------------------------------------------------
;   Description   auxiliary quantlet for multi
; -----------------------------------------------------------------
;   Usage         d =strucbru(b,covb,di,ord,adj,tb,te,t,covu,typ,ytt,outp)
;   Input
;     Parameter   b 
;     Definition    matrix 
;     Parameter   covb 
;     Definition    matrix, covariance of b 
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   ord 
;     Definition    integer, order of series
;     Parameter   adj 
;     Definition    scalar, 1=if adjusted, 0=if not
;     Parameter   tb 
;     Definition    integer, (time) begin 
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   t 
;     Definition    integer, number of observation time points
;     Parameter   covu 
;     Definition    matrix, covariance  
;     Parameter   typ 
;     Definition    integer, describing the model type
;     Parameter   ytt
;     Definition    vector, the transformed time series
;     Parameter   outp
;     Definition    matrix 
;   Output
;     Parameter   d
;     Definition     matrix 
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971212
; -----------------------------------------------------------------
  if (cols(ytt)>te)
    str = " Forecast horizon ( < no. of. observ. - end of sample + 1 ) : "
    h=readvalue(str, 5);
    if (h<>0)
      yh=prognose(b,zeros(di,1),ord,h,te,di,adj,typ,ytt);
      covf=covforec(b,covb,covu,di,ord,adj,tb,te,t,h,typ,ytt);
      bbig=aorBgen(b,di,ord,adj,typ);
      jota=jotaAorB(di,ord,adj,typ);
      phi=phigen(bbig',jota,h,ord,di,typ);
      d=station(vec(yh),phi',inv(covu),covf,di,ord,te,t,h,ytt,outp);
    endif;
  else; 
      selectitem(" ", " Check end of sample! ")
  endif;
endp;
