proc(sm)=supsmo(xy)
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;   Macro        supsmo
; -----------------------------------------------------------------
;   Keywords     super smoother, regression                
; -----------------------------------------------------------------
;   Description  calculates the super smoother 
; -----------------------------------------------------------------
;   Usage        sm=supsmo(xy)
;   Input
;     Parameter  xy  
;     Definition   n x 2, the data. In the first column the
;                  independent, in the second column the
;                  dependent variable. 
;   Output
;     Parameter  sm  
;     Definition   n x 2 matrix, the first column is the independent
;                  variable xy[,1] and the second column contains the 
;                  fitted values.
; -----------------------------------------------------------------
;   Example   library("smoother") 
;             library("plot")
;             xy = read("motcyc")           
;             sm=supsmo(xy)
;             sm = setmask(sm,"line","red")
;             plot(xy, sm) 
; -----------------------------------------------------------------
;   Result    plot of super smoother and the original data    
; -----------------------------------------------------------------
;   Author    Fabian Noetzel 991208
; -----------------------------------------------------------------
  error(cols(xy)<>2,"supsmo: cols(xy) <> 2")
  nx=countNotNumber(xy)
  error(sum(nx)>0, "supsmo: missing or infinite values")
  xy=sort(xy)
  n=prod(dim(xy[,2]))
  sm=matrix(rows(xy[,2]),cols(xy[,2])).*NaN
  param = list(xy[,1], xy[,2], n, sm)
  byrow = 0|0|0|0
  type = 8|8|-8|8
  opt = list(type, byrow)
  os=getenv("os")
  if (os=="windows")
    h = dlopen("regression.dll")
    err = dlcallex(h, "_supsmo", param, opt)
  else
    h = dlopen("regression.so")
    err = dlcallex(h, "supsmo", param, opt)
  endif 
  dlclose()
  sm=xy[,1]~param.sm
endp