 proc(y)=symweigh(x,h,n,f)

; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;   Macro       symweigh
; -----------------------------------------------------------------
;   Description  symweigh computes the symmetrical weights
; -----------------------------------------------------------------
;   Usage        y = symweigh (x, h, n, f)
;   Input
;     Parameter  x  
;     Definition  n x 1 vector
;     Parameter  h  
;     Definition  n x 1 vector or number
;     Parameter  n  
;     Definition  n x 1 vector or number
;     Parameter  f  
;     Definition  1 x 1 address of function
;   Output
;     Parameter  y  
;     Definition  k x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x=(0.1)*(1:4)                                             
;             h=x                                                      
;             n=10*x+1                                             
;             y = symweigh(x, h, n, "qua") 
;             y                                
; -----------------------------------------------------------------
;   Result    Contents of y
; -----------------------------------------------------------------
;   Author    Sigbert Klinke, Stefan Sperlich, 
;             Wolfgang Stockmeyer, 951124  Lijian Yang, 960321   
; -----------------------------------------------------------------


  if (rows(h)<2)
     h=matrix(rows(x))*h
  endif
  if (rows(n)<2)
     n=matrix(rows(x))*n
  endif
  g=grid(x,h,n) 
  m=2^sum((g.<>0),2) 
  w=_f(g) 
  s=sum((m.*w),1)
  y=w./s

endp
