proc(x1,x2,t)=table2(x)
; ----------------------------------------------------------------------------
;  Library      stats
; ----------------------------------------------------------------------------
;  See_also     crosstable discrete 
; ----------------------------------------------------------------------------
;   Macro       table2
; ----------------------------------------------------------------------------
;   Description  computes a two way table from two-dimensional data.
; ----------------------------------------------------------------------------
;   Keywords    two way table, crosstable, contingency table
; ----------------------------------------------------------------------------
;   Usage        {x1,x2,t}=table2(x)
;   Input
;     Parameter   x  
;     Definition        n x 2  matrix, the columns correspond to the variables.
;   Output
;     Parameter   x1
;     Definition        p x 1  vector, distinct realizations of x[,1].
;     Parameter   x2
;     Definition        q x 1  vector, distinct realizations of x[,2].
;     Parameter   t
;     Definition        p x q  matrix, the absolute frequencies (the inner 
;                              part of the crosstable).
; ----------------------------------------------------------------------------
;   Example   library("stats") 
;             x=read("drosop")
;             table2(x[,6:7])
; ----------------------------------------------------------------------------
;   Result    realizations and crosstable of the columns x[,6:7]
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 970325
; ----------------------------------------------------------------------------
  error((dim(dim(x))!=2 || cols(x)!=2),"input should be n x 2")
  if (exist(x)==9)
    x=x{1}
  endif
  if (exist(x)==1)
    x=(0*matrix(rows(x),2)).*(x==0)+x.*(x!=0)
  endif
;
  {x1,r1}=discrete(x[,1])
  {x2,r2}=discrete(x[,2])
  havestring=(exist(x1)==2)
;
  if (havestring)
    havestring=1
    xc1=x1
    xc2=x2
    x1=1:rows(x1)
    x2=1:rows(x2)
    xc=x
    x=sum((xc[,1]==xc1').*x1',2)~sum((xc[,2]==xc2').*x2',2)
  endif
;
  n1=rows(x1)
  n2=rows(x2)
  tmp=matrix(n1,n2)
  g1=reshape(x1.*tmp,#(n1*n2,1))
  tmp=reshape(x2.*tmp',#(n1*n2,1))
  g2=discrete(tmp~(1:rows(tmp))) ; discrete sorts data with 
  g2=g2[,1]                      ; NaN's correctly!!
;
  {xr,r}=discrete(x|(g1~g2))
  r=r-1
  t=reshape(r,#(n2,n1))
  t=t'
;
  if (havestring)
    x1=xc1
    x2=xc2
  endif
endp

