library("xplore")
;
; **** T-GARCH prog
;
proc(st,pt) = tgarch(n, m, a1, a2, b, lambda, r, s0,c)
;
	c=0.01.*c
	r=(r+1)^(1/10)-1
	st = matrix(m,1).*s0 
	s2 = matrix(m,1).*c./(1-(a1+a2)/2-b)
	xi = sqrt(s2).*normal(m,1)
	eps = xi - lambda.*sqrt(s2)
	pt=s0
	yt=0	
	i = 1;
	while (i<=n)
	j=1
		while (j<=10)
       			s2 = c + (a1.*(eps.>0)+ a2.*(eps.<0)).*eps^2 + b*s2
	       		xi = sqrt(s2).*normal(m,1)
        		eps = xi - lambda.*sqrt(s2)
  		   	st = st .*exp(r - s2./2 + xi)
			pt = pt | mean(st)
	j=j+1
	endo
        i = i+1;
    endo;
endp
;
; 
; **** GARCH prog
;
proc(st,pt) = garch(n,m,a,b,c,lambda,r,s0);
	r=(r+1)^(1/10)-1
	c=0.01*c
	st = matrix(m,1).*s0;
	s2 = matrix(m,1).*c./(1-(1+lambda^2)*a-b);
	xi = sqrt(s2).*normal(m,1);
	pt=s0
	yt=0
    	i = 1;
   	while (i<=n)
 	j=1
		while (j<=10)
        		s2 = c + a*(xi-lambda*sqrt(s2))^2+b*s2;
        		xi = sqrt(s2).*normal(m,1);
			st = st .* exp(r - s2./2 + xi);
			pt = pt | mean(st)
			j=j+1
		endo
	i = i+1;
	endo;
endp
;
;
; **** risk neutral pricing
;
proc(c0) = norisk(s,r,n,ex)
        c0 =0*matrix(rows(ex),1);
	i=1;
  while  (i<=rows(ex))
        c0[i] = exp(-n*r).*mean((s - ex[i]).*((s-ex[i]).>0))
	i=i+1;
  endo;
endp;
;
;
;**** black and scholes
;
proc(bsprice) = black(ex,ms2,s0,n,r);
	n=n+1
	if (ms2<0.0000000001)
		d1=1
		d2=1
	else
		d1 = (log(s0./ex)+(r+(ms2./2)).*n)./sqrt(ms2.*n)
		d2 = d1-sqrt(ms2*n)
		d1 = cdfn(d1)
		d2 = cdfn(d2)
	endif
	bsprice = s0.*d1 - ex.*d2.*exp(-n*r)
	bsprice = bsprice.*(bsprice.>0)
endp
;
;
;****main program
;
proc() = tgarsim()
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       optstart, stocksim
; -----------------------------------------------------------------
;   Macro         tgarsim
; -----------------------------------------------------------------
;   Description   tgarsim is plotting the difference between
;                 option prices by Black/Scholes and using 
;                 risk neutral, GARCH or Treshold GARCH models
; -----------------------------------------------------------------
;   Usage         tgarsim()
;   Input        
;   Output       
; -----------------------------------------------------------------
;   Example       library("finance")
;                 tgarsim()
; -----------------------------------------------------------------
;   Result        a display plotting the stock price simulation, 
;                 option prices, absolute and relative difference
; ---------------------------------------------------------------------
;   Reference     Haerdle,Hafner(1996): DP of SFB373
; -----------------------------------------------------------------
;   Author    Hafner, Kath, Sperlich  970414 
; -----------------------------------------------------------------
c = 0.0001641;                                  constant parameter of (T-)GARCH model          
a = 0.00614;                                     alpha parameter of GARCH model       
b = 0.09244
bg =  b;                                     beta parameter of (T-)GARCH model
a1 = 0.9*a;					Parameter for TGARCH (case: eps>0)
a2 = 0.2*a;					Parameter for TGARCH (case: eps<0)
lambda = 0.001;                                 lambda (factor for the influence of the volatility in the price process)
s0 = 685.7;                                     value of stock at time t=0 
jzins = 0.08;                                   interest rate 
r =(jzins+1)^(1/250)-1;                        discounting factor (days=250) 
n = 15;                                        days to maturity 
m = 100;					number of tossings
money = aseq(0.85, 31, 0.01);			range for moneyness
e = s0./money;					exercise price
;
;
; Abfrage der Basis-Modellwerte
;
valuestrs="Interest rate" | "Lambda" | "Initial Value of Stock" | "Black/Scholes volatility" | "Number of shocks" | "Days to maturity" 
       values=jzins | lambda | s0 | c | m | n 
       values=readvalue(valuestrs, values)
  jzins=values[1]
  lambda=values[2]
  s0=values[3]
  c=values[4]
  m=values[5]
  n=values[6]
;
;
;
; Auswahl der Modellparameter fuer GARCH und TGARCH
;
headline="Model specification" 
	items="GARCH" | "T-GARCH" 
	i=selectitem(headline, items)
while (i[1] || i[2])
	if (i[1])
		do
			valuestrs="alpha=" | "beta=" 
       			values=a | bg
       			values=readvalue(valuestrs, values)
			a=values[1]
			bg=values[2]
		until (1-a-bg>0)	
		i=selectitem(headline, items)
	endif
	if (i[2])
		do
			valuestrs="alpha1=" | "alpha2="| "beta=" 
	       		values=a1 | a2 | b 
       			values=readvalue(valuestrs, values)
			a1=values[1]
			a2=values[2]
			b=values[3]
		until (1-((a1+a2)/2)-b>0)	
		i=selectitem(headline, items)
	endif
endo
;
;
;
;  **** Anzeige der Wertpapier-Preisprozesse
;
{s1,p1}=tgarch(n,m,a1,a2,b,lambda,r,s0,c)
{s2,p2}=garch(n,m,a,bg,c,lambda,r,s0)
d = createdisplay(2,2)
;d1 = createdisplay(1,1)
t1=1:rows(p1)
t2=1:rows(p2)
t1=t1./10
t2=t2./10
dat1=t1~p1
setmaskl(dat1,(1:rows(dat1))',1,1,2)
setmaskp(dat1,0,0,8)
dat2=t2~p2
setmaskl(dat2,(1:rows(dat2))',4,1,2)
setmaskp(dat2,0,0,8)
show(d,1,1,dat1,dat2)
setgopt(d,1,1,"xlabel","Days","ylabel","DM","title","Stock price simulation")
;
;
; ***** Berechnung der Call-Preise
;
e = s0./money;					execution price
;
;
nppr = norisk(s1,r,n,e);		Call-Preis unter TGARCH
gpr  = norisk(s2,r,n,e);		Call-Preis unter GARCH
bs   = black(e,c,s0,n,r);		Call-Preis unter Black Scholes
;
; prepare plotting
;
absdiff1 = (gpr - bs);
reldiff1 = ((gpr - bs)./bs);
absdiff2 = (nppr - bs);
reldiff2 = ((nppr - bs)./bs)
;
;
sel=(bs.>0.000000000000001)
;
; plotting
;
;d = createdisplay(2,2)
dat1 = money~gpr
setmaskp(dat1,0,0,0)
setmaskl(dat1, (1:rows(dat1))', 1,1,2)
dat2 = money~bs
setmaskp(dat2,0,0,0)
setmaskl(dat2, (1:rows(dat2))', 0,1,2)
dat3 = money~nppr
setmaskp(dat3,0,0,0)
setmaskl(dat3, (1:rows(dat3))', 4,1,2)
show(d,1,2,dat1,dat2,dat3)
setgopt(d,1,2,"xlabel","Moneyness","ylabel","DM","title","Option Prices")
;
;
; now abs diff s
;
dat1 = money~absdiff1
setmaskp(dat1,0,0,0)
setmaskl(dat1, (1:rows(dat1))', 1,1,2)
dat2 = money~absdiff2
setmaskp(dat2,0,0,0)
setmaskl(dat2, (1:rows(dat2))', 4,1,2)
show(d,2,1,dat1,dat2)
setgopt(d,2,1,"xlabel","Moneyness","ylabel","Abs. Diff.","title","Absolute Difference")
;
;
; now rel diff s
;
dat1 = money~reldiff1
dat2 = money~reldiff2
 dat1=paf(dat1,sel)
 dat2=paf(dat2,sel) 
setmaskp(dat1,0,0,0)
setmaskl(dat1, (1:rows(dat1))', 1,1,2)
setmaskp(dat2,0,0,0)
setmaskl(dat2,(1:rows(dat2))', 4,1,2)
show(d,2,2,dat1,dat2)
setgopt(d,2,2,"xlabel","Moneyness","ylabel","Rel. Diff.","title","Relative Difference")
;
;
endp
