proc (dummy) = timeplot (x,len,header)
; ----------------------------------------------------------------------
; Library 	  times
; ----------------------------------------------------------------------
;  See_also	  
; ----------------------------------------------------------------------
;   Macro	  timeplot
; ----------------------------------------------------------------------
;   Description   plots a time series in multiple windows with 
;                 user-specified maximum length per window                
; ----------------------------------------------------------------------
;   Usage         timeplot(x {, len {,header}})
;   Input 
;     Parameter   x 
;     Definition  vector (time series)
;     Parameter   len (optional)
;     Definition  Integer (maximum length plotted in a window, 
;                 default 400)
;     Parameter   header (optional)
;     Definition  list object 
;     Parameter   header.name 
;     Definition  name of time series 
;     Parameter   header.origyear 
;     Definition  beginning data of time series 
;     Parameter   header.origperiod 
;     Definition  origperiod period in the beginning year 
;     Parameter   header.periodicity 
;     Definition  beginning data of time series 
; ----------------------------------------------------------------------
;   Example       library("times")
;                 x=normal(100)
;		              t = timeplot(x)
; ----------------------------------------------------------------------
;   Result        generates a graphical display showing time series
; ----------------------------------------------------------------------
;   Author        Rong Chen, Christian Hafner, 970723
; ----------------------------------------------------------------------
if (exist(len)==0)
  len=400
endif
if (exist(header)<>9)
  name=" "
  origyear=1
  origperiod=1
  periodicity=1
  header=list(name,origyear,origperiod,periodicity)
endif
len=floor(len)
n=rows(x)
m=ceil(n/len)
k=floor(n/m)
t=grid(header.origyear+(1/header.periodicity)*(header.origperiod-1),(1/header.periodicity),n)
z=t~x
dtime=createdisplay(m,1)
i=1
while(i<=m)
  w=z[(i-1)*k+1:i*k,]
  if (i==m)
    w=z[(i-1)*k+1:n,]
  endif
  w=setmask(w,"line","solid")
  if(n<40)
    w=setmask(w,"points","star","line","solid")
  endif
  show(dtime,i,1,w)
  setgopt(dtime,i,1,"ylim",min(x)|max(x),"title",header.name)
  i=i+1
endo
dummy=0
endp
