
proc (y) = trian(x) 

; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     cosi epa gau qua tri uni
; -----------------------------------------------------------------
;   Macro      trian
; -----------------------------------------------------------------
;   Description  trian computes the triangle kernel, multivariate
; -----------------------------------------------------------------
;   Usage        y = trian(x)
;   Input
;     Parameter  x  
;     Definition  n x p matrix
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 21, 0.1) 
;             y = trian(x) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Isabel Proenca & Lijian Yang, 951117   
; -----------------------------------------------------------------


  y = prod((1 .- abs(x)).*(abs(x).<1),2)    

endp  
   
