proc(uselret)=twles9(usel)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     twles1 twles2 twles3 twles4 twles6 twles7 twles8
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        twles9
; -----------------------------------------------------------------------
; Description  Shows in the left window the true function plus noise
;              and in the right a translation invariant estimator
;              with k=4*log_2(n) shifts.
; -----------------------------------------------------------------------
; Usage        twles9()
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961125
; -----------------------------------------------------------------------
  if (existglobal("DisplaySize"))
    ds = getglobal("DisplaySize")
  else
    ds = 400
  endif
  setsize (2*ds, ds)
  d9 = createdisplay(1,2)
  n = 128
  dev = 0.1
  {tmp, x1} = chfunc (NaN, 0, n, #(0,0,0,1))
  randomize(0)
  x2 = x1+dev*normal(n)
  h = getglobal ("haar")
  l = 4
  v = 3
  selhead = "Wavelet lesson 9"
  selitem = "Change basis"|"Change level"|"Change function"|"Noise level"|"Print"
  end = 0
  xs  = fwttin (x2, l, h)
  t   = ((1:n)-0.5)/n 
  do
    tx2 = t~x2
    setmaskp(tx2,0,0,0)
    setmaskl(tx2,(1:n)',0,1,2)
    show (d9, 1, 1, tx2)  
    txs = t~xs
    setmaskp(txs,0,0,0)
    setmaskl(txs,(1:n)',0,1,2)
    show (d9, 1, 2, txs)
    ru = rows(usel)
    if (ru.>1)
      sel  = (usel[2].=(1:8))
      if (ru.>2)
        usel = usel[1]|usel[3:ru]
      else
        usel = usel[1]
      endif
    else
      sel = selectitem (selhead, selitem)
    endif
    end = sum(sel).=0
    if (sel[1])
      {usel, h} = chbase (usel, h)
       xs  = fwttin (x2, l, h)     
   endif
    if (sel[2])
      ru = rows(usel)
      if (ru.>1)
        l    = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        do
          l = readvalue ("Change level", l)
        until ((l>3) && (l<rows(x1)))
      endif
      l = 2^floor(log(l)./log(2))
      xs  = fwttin (x2, l, h)     
    endif  
    if (sel[3])
      {usel, x1} = chfunc(usel, x1, n, 0)
      randomize(0)
      x2 = x1+dev*normal(n)
      xs  = fwttin (x2, l, h)     
    endif
    if (sel[4])
      ru = rows(usel)
      if (ru.>1)
        dev = usel[2]
        if (ru.>2)
          usel = usel[1]|usel[3:ru]
        else
          usel = usel[1]
        endif
      else
        dev = readvalue ("Deviation:", dev)
      endif
      randomize(0)
      x2 = x1+dev*normal(n)
      xs  = fwttin (x2, l, h)
    endif
    if (sel[5])
      usel = twprint (d9, usel)
    endif
  until (end)
  uselret = usel
endp
