proc()=twskew(val)
; -------------------------------------------------------------------------------
;   Library      tware
; -------------------------------------------------------------------------------
;   See_also     twpvalue, tw1d, twrandomsample, twnormalize, twclt, twpearson, twlinreg, twtest
; -------------------------------------------------------------------------------
;   Macro        twskew
; -------------------------------------------------------------------------------
;   Description  teachware quantlet
;                shows effects on skewness and kurtosis by contamination of a normal distribution
; -------------------------------------------------------------------------------
;   Usage        twskew({val})
;   Input        val  vector(6x1)
; -------------------------------------------------------------------------------
;   Example      ; load teachware library
;                library("tware")
;                ; predefinition of default values
;                val=100 | 0 | 2 | 1 | 1 | 0.1
;                ; call skewness teachware example
;                twskew(val)
; -------------------------------------------------------------------------------
;   Result       a plot of true density and histogramm of simulated values as well as values for skewness and kurtosis
; -------------------------------------------------------------------------------
;   Link         
; -------------------------------------------------------------------------------
;    Author      RJ 000910
; -------------------------------------------------------------------------------
if (exist(val)<>1)
  val=100 | 0 | 2 | 1 | 1 | 0.1  ; default values
endif
val=readvalue("Sample size n"|"mean1"|"mean2"|"standard deviation1"|"standard deviation2"|"contamination rate",val)
error(val[1]<0,"Negative argument!")
error((val[6]<0)||(val[6]>1),"Mixing rate must be in [0,1]")
error((val[4]<=0)||(val[5]<=0),"Standard deviations must be positive")
xmin=min((val[2]-3.5*val[4])|(val[3]-3.5*val[5]))
xmax=max((val[2]+3.5*val[4])|(val[3]+3.5*val[5]))
n=100
x=xmin+(xmax-xmin)/(n-1) .* (0:n-1)
y1=(1-val[6])*pdfn((x-val[2])/val[4])/val[4]       ; original normal distribution
y2=val[6]*pdfn((x-val[3])/val[5])/val[5]    ; contaminating distribution
y3=y1+y2  ; concatenation of the 2 normals
z1=setmask(x~y1, "line", "red")
z2=setmask(x~y2, "line", "green")
z3=setmask(x~y3, "line", "black")
; simulating contaminated distribution
m2=round(val[6]*val[1]) ; no. of elements of contaminated distribution
m1=val[1]-m2
if (m1>=1)
xr1=normal(m1,1,1)*val[4]+val[2]
else
endif
if (m2>=1)
xr2=normal(m2,1,1)*val[5]+val[3]
else
endif
switch
case ((m1>=1)&&(m2>=1))
xr=xr1|xr2
case ((m1>=1)&&(m2<1))
xr=xr1
case ((m1<1)&&(m2>=1))
xr=xr2
endsw
xrmax=max(xr)
xrmin=min(xr)
range=xrmax-xrmin
b=range/round(10*log10(val[1]))
gr=grhist(xr,b,val[2])
kx=kurtosis(xr)
sx=skewness(xr)
  disp = createdisplay(2,1)
  show (disp, 1, 1, gr,z1,z2,z3)
  show (disp, 2, 1, string("Skewness of x is %2.4f", sx)|string("Kurtosis of x is %2.4f.", kx))
title = "Distribution of contaminated normal distribution"
setgopt(disp,1,1,"title",title)
endp
