proc(txt)=variableinfo(data)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista 
; -----------------------------------------------------------------------
; Macro        variableinfo
; -----------------------------------------------------------------------
; Description  gives general information concerning the name, the type
;              and the number of NaNs in each variable of the dataset and
;              shows if the variables and cases are in/excluded. 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  r=rows(data.x)
  c=cols(data.x)
  cstr=string("%.0f",c)+" variables"
  rstr=string("  %.0f",r)+" cases"
  txt = "Info about variables"+" ("+cstr+rstr+")"
  txt = txt|"-----------------------------------------------------------------"
  nc="continuous"|"discrete  "
  d=(data.coltype<>0)+1  
  ni="excluded"|"included" 
  di=((data.colvar<>0)&&(data.colmissing<>0))+1  
  df=((sum(data.rowcase)==rows(data.rowcase))&&(sum(data.rowmissing)==rows(data.rowmissing))&&(sum(data.randcase)==rows(data.randcase)))  
  datah=paf(data.x,data.rowmissing)
  ;if cases are excluded because of NaNs
  i=0 ;count NaNs again
  nan=0 
  while(i<cols(datah))
    i=i+1
    c=countNaN(datah[,i])
    nan=nan|c  
  endo
  data.nan=nan[2:rows(nan)]
  na=string ("(%.0f NaNs)", data.nan)
  if(df)
    nf="all cases included"
  else
    nf="cases excluded"
  endif
  txt = txt|(string ("%2.0f ", 1:cols(data.x))+" ("+nc[d]+") ("+ni[di]+")("+nf+") "+na+" "+data.colname)
endp
