proc(d1)=varorder(tb,te,t,di,diff,typ,ytt,outp)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      modelfr
; -----------------------------------------------------------------
;   Macro         varorder
; -----------------------------------------------------------------
;   Description   standard selection criteria for Full VAR models
; -----------------------------------------------------------------
;   Usage         d1 = varorder(tb,te,t,di,diff,typ,ytt,outp) 
;   Input
;     Parameter   tb 
;     Definition    integer, (time) begin 
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   t 
;     Definition    integer, number of observation time points
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   diff 
;     Definition    integer, difference of lags
;     Parameter   typ 
;     Definition    integer, describing the model type
;     Parameter   ytt
;     Definition    vector, the transformed time series
;     Parameter   outp
;     Definition    matrix 
;   Output
;     Parameter   d1
;     Definition     matrix, the estimated coefficients
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971212
; -----------------------------------------------------------------
  anz=readvalue(" Max order? ", 2)
  if (anz>=tb-diff)
    " Too large! Check sample beginning! "
  else
    if (anz*di+1>=te-tb+1)
      " Degrees of freedom < 1! Reduce order! "
    else
      m=0;
      crit=zeros(1,4);
      while (m<=anz)
        detcovml=det((t-di*m-1)/t*covres(m,di,tb,te,0,typ,ytt));
        lndet=log(detcovml);
        crit=crit|(((t+di*m+1)/(t-di*m-1))^di*detcovml~lndet+2*m*di*di/t~lndet+2*m*di*di*log(log(t))/t~lndet+m*di*di*log(t)/t);
        m=m+1;
      endo;
      crit=crit[2:anz+2,];
      crit[,1]=log(crit[,1])   ; FPE is very large
      d1 = createdisplay(1,cols(crit)+1)
      str1="Order"|" "|string("%3.0f",aseq(0,anz+1,1))
      show(d1,1,1,str1)
      str2="ln(FPE)"|" "|string("%5.4f",crit[,1])
      show(d1,1,2,str2)
      str3=" AIC"|" "|string("%5.4f",crit[,2])
      show(d1,1,3,str3)
      str4="   HQ"|" "|string("%5.4f",crit[,3])
      show(d1,1,4,str4)
      str5="    SC"|" "|string("%5.4f",crit[,4])
      show(d1,1,5,str5)
      if (outp==1)
        " VAR Order Criteria"
        str1+"  "+str2+"  "+str3+"  "+str4+"  "+str5
      endif
    endif
  endif
endp;
