proc(d)=vec2mat(v)
; -----------------------------------------------------------------------
; Library     xclust 
; -----------------------------------------------------------------------
; See_also    mat2vec distance lpdist agglom corrdist 
; -----------------------------------------------------------------------
; Macro       vec2mat
; -----------------------------------------------------------------------
; Description stores the values of a vector into the upper
;             triangle of a symmetric matrix regarding the
;             sequence described in agglom
; -----------------------------------------------------------------------
; Usage       d = vec2mat(v) 
; Input
;   Parameter  v
;   Definition n(n-1)/2 x 1 matrix containing the values of the       
;                           upper triangle of a symmetric matrix
;
; Output
;   Parameter  d
;   Definition n x n  symmetric matrix with zeros in the diagonal
; -----------------------------------------------------------------------
; Example     ; load the library xclust
;             library ("xclust")
;             ; generate vector
;             v = #(2, 3, 7, 1, 8, 5)
;             ; apply vec2mat
;             vec2mat(v)
; -----------------------------------------------------------------------
; Result      Content of object d
;
;             [1,]        0        2        3        7 
;             [2,]        2        0        1        8 
;             [3,]        3        1        0        5 
;             [4,]        7        8        5        0 
; -----------------------------------------------------------------------
; Author      Hans-Joachim Mucha, 950121
;             Sigbert Klinke, 970902
; -----------------------------------------------------------------------
  k=rows(v).*2
  j=ceil(sqrt(k))
  d=0.*matrix(j, j)
  i=1
  do
    k=0
    i=i+1
    do
      k=k+1
      m=j*(k-1)-k*(k-1)/2+i-k
      d[k,i]=v[m,1]
      d[i,k]=v[m,1]
      until(k.=i-1)
  until(i.=j)      
endp      