; -----------------------------------------------------------------
;   Macro       vertestb
; -----------------------------------------------------------------
;   Description  tests all libraries. Similar to vertestl but
;                without menu.
; -----------------------------------------------------------------
;   Usage        vertestb()
; -----------------------------------------------------------------
;   Example   func("vertestb")
;             vertestb()
; -----------------------------------------------------------------
;   Author  Marlene Mueller, 971210
; -----------------------------------------------------------------
;
proc()=vertestb()
  if (existglobal("ReportPath"))
    ReportPath=getglobal("ReportPath")+"/"
  else
    ReportPath=""
  endif
;
; Note: libs = list of ALL libs
;       not  = libs that can NOT be called IN BATCH
;
  libs=     "eiv"
  libs=libs|"finance"
  libs=libs|"gam"
  libs=libs|"glm"
  libs=libs|"gplm"
  libs=libs|"graphic"
  libs=libs|"hazreg"
  libs=libs|"kernel"
  libs=libs|"math"
  libs=libs|"metrics"
  libs=libs|"multi"
  libs=libs|"nn"
  libs=libs|"plm"
  libs=libs|"rpclib"
  libs=libs|"smoother"
  libs=libs|"stats"
  libs=libs|"times"
  libs=libs|"twave"
  libs=libs|"wavelet"
  libs=libs|"xclust"
  libs=libs|"xplore"
;
  status=string("could not be checked !!",1:rows(libs))
;
  notload=        "auto"
  notload=notload|"rpclib"
  notload=notload|"nn"
  notload=notload|"twave"
;
  nottest=        "graphic"
  nottest=nottest|"metrics"
  nottest=nottest|"nn"
;  nottest=nottest|"smoother"
;
  line = "=============================================="
  report = line
;
  j=0
  while (j<rows(libs))
    j=j+1
    if (sum(notload==libs[j])>0)
      (" !!! "+libs[j]+"test"+" NOT TESTED !!!")
      status[j]="can't be loaded in batch"
    else   
      library(libs[j])
      if ((exist(libs[j]+"test")>0)&&(sum(nottest==libs[j])==0))
        exec( libs[j]+"test()" )
        (" LIBRARY CHECK FOR "+libs[j]+" FINISHED")
        status[j]="test finished ok"
      endif
      if (exist(libs[j]+"test")<=0)
        (" !!! NO "+libs[j]+"test"+" MACRO AVAILABLE !!!")
        status[j]="no test available"
      endif
      if (sum(nottest==libs[j])>0)
        (" !!! "+libs[j]+"test"+" COULD NOT BE TESTED !!!")
        status[j]="can't be tested in batch, load ok"
      endif
    endif
    tmp=substr(libs+"            ",1,11)
    tmp=tmp+string(" ... ",1:rows(libs))+status
    CurrentReport=line|tmp|line
    CurrentReport
    if (ReportPath!="")
      write(CurrentReport,ReportPath+"vertestb.report")
    endif
  endo
endp
;
vertestb()




