proc()=waveint4b(disp, col, a, b, x, dl, l, h)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     waveint1b waveint2b waveint3b waveint5b
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        waveint4b
; -----------------------------------------------------------------------
; Description  Shows the mother wavelet for a given basis.
;              In the picture of the first row the function is shown. 
;              Below, in the second row, we see as lowest function the
;              approximation with only using the father wavelet
;              coefficients. Then we add the first level of mother 
;              wavelet coefficients to the approximation, then
;              the first and the second level and so on.
; -----------------------------------------------------------------------
; Usage        waveint4b(disp, col, a, b, x, dl, l, h)
; Input
;   Parameter  disp 
;   Definition display
;   Parameter  col
;   Definition scalar,		which column of disp is used
;   Parameter  a
;   Definition l x 2,    	father wavelet coefficients 
;   Parameter  b
;   Definition (n-l) x 3, 	mother wavelet coefficients
;   Parameter  x
;   Definition n x 1,	data
;   Parameter  dl
;   Definition scalar,           0 - function will be drawn as points, 
;				1 - function will be drawn as line
;   Parameter  l
;   Definition scalar,           number of father wavelet coefficient
;   Parameter  h
;   Definition m x1, 		wavelet basis coefficients
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960916
; -----------------------------------------------------------------------
; dataset for the x's 
  xn  = rows(x)
  t     = (((1:xn)-0.5)./xn)
  xx  = t~x
  if (dl)
    setmaskp(xx, 0, 0, 0)
    setmaskl (xx,  (1:rows(xx))', 0, 1, 3)
  endif 
  show (disp, 1, col, xx)
  setxaxis (disp, 1, col, -0.05, 1.05, 0, 0.2, 0.1, 0, 1)
; max coeff
  li  = min(b[,1])
  la = max(b[,1])
  bt = b[,1:2]~(b[,3].*0)
  xt = invfwt(a,bt, xn, l, h)
  xt = t~(li-1.25+0.5.*(xt-min(xt))./(max(xt)-min(xt)))
  if (dl)
    setmaskp(xt, 0, 0, 0)
    setmaskl (xt,  (1:xn)', 0, 1, 3)
  endif 
  show (disp, 2, col, xt)
  i   = li
  while (i.<=la)
     bt = b[,1:2]~(b[,3].*(b[,1].<=i))
     xt = invfwt(a,bt, xn, l, h)
     xt = t~(i-0.25+0.5.*(xt-min(xt))./(max(xt)-min(xt)))
     if (dl)
       setmaskp(xt, 0, 0, 0)
       setmaskl (xt,  (1:xn)', 0, 1, 3)
     endif 
     adddata (disp, 2, col, xt)
     i = i+1
  endo
  setxaxis (disp, 2, col, -0.05, 1.05, 0, 0.2, 0.1, 0, 1)
  setyaxis (disp, 2, col, min(b[,1])-2, max(b[,1])+1, 0, 1, 0.5, 0, 1)
endp
