proc(d)=xdiag(x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      diag
; -----------------------------------------------------------------
;   Keywords     matrix manipulation, matrix
; -----------------------------------------------------------------
;   Macro        xdiag
; -----------------------------------------------------------------
;   Description  Extracts diagonal elements from matrices.
; -----------------------------------------------------------------
;   Usage        d = xdiag (x)
;   Input
;     Parameter  x
;     Definition n x n x d1 x d2 ... array of quadratic matrices
;   Output
;     Parameter  d
;     Definition n x 1 x d1 x d2 ... array of diagonal elements 
; -----------------------------------------------------------------
;   Example   library("xplore")
;             xdiag (diag (1:4))
; -----------------------------------------------------------------
;   Result
;             Contents of d
;	      [1,]     1
;	      [2,]     2 
;	      [3,]     3 
;	      [4,]     4 
; -----------------------------------------------------------------
;   Author    Sigbert Klinke, 980519
; -----------------------------------------------------------------
  error(cols(x)!=rows(x),"matrix must be quadratic")
  n = rows(x)
  dm = dim(x)
  dm[1] = n*n
  if (rows(dm)>1)
    dm[2] = 1
    reshape ("x", dm)
  endif
  i = (0:(n-1))*n+(1:n)
  d = x[i]
endp
