proc(yh)=xgobineunet(x,y,g,hidden)
; -----------------------------------------------------------------------
; Library      rpclib
; -----------------------------------------------------------------------
; See_also     xgobilocpol xgobilowess xgobinadawat  
; -----------------------------------------------------------------------
; Macro        xgobineunet
; -----------------------------------------------------------------------
; Description  conmputes a neural network fit for XGobi
; -----------------------------------------------------------------------
; Usage        yh = xgobineunet(x,y,g,hidden)
; Input
;   Parameter  x
;   Definition n x 1    matrix
;   Parameter  y
;   Definition n x 1    matrix
;   Parameter  g
;   Definition n x 1    matrix with integers starting at zero
;   Parameter  hidden
;   Definition scalar   number of hidden units 
; Output
;   Parameter  yh
;   Definition n x 1    matrix smoothed fit
; -----------------------------------------------------------------------
; Notes        XGobi gives hidden as negative number which allows the user
;	       to use the macro for other purposes. We expect that XGobi
;              sets hidden between -333 and -3900.
; -----------------------------------------------------------------------
; Example      ; load the library for XGobi
;	       library ("rpclib")
;              ; create a display
;	       d=createdisplay(1,1)
;	       ; read a data set
;  	       x=read("motcyc")
;              ; generate randomly three subgroups
;  	       g=floor(3.*uniform(rows(x)))
;              ; color the data after the subgroups
;              setmaskp (x, g, 3, 4)
;              ; show the data and the smooth
;              show (d, 1, 1, x, x[,1]~xgobineunet(x[,1],x[,2],g,10))
; -----------------------------------------------------------------------
; Result       shows a neural network fit of for the three 
;	       different subgroups in the data
; -----------------------------------------------------------------------
; Link         http://www.public.iastate.edu/~dicook/research/software.html XGobi
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960709
; -----------------------------------------------------------------------
  if (hidden<0)
    hidden = ceil(abs(4000+hidden)/50)
    string ("hidden unit: %.0f", hidden)
  endif
  i  = 0
  mg = 1+max(g)
  yh = y
  k  = 1:rows(x)
  while (i<mg)
    xg = paf(x, g.=i)
    yg = paf(y, g.=i)
    kg = paf(k, g.=i)
    xg = sort(xg~yg~kg)
    yg = xg[,2]
    kg = xg[,3]
    xg = xg[,1]
    xg = (xg-min(xg))./(max(xg)-min(xg))
    net = nnrnet (xg, yg, matrix(rows(xg)), hidden, 1|0|0|0|0.7|0.001|1000|0) 
    yh[kg] = net.yh
    i = i+1
  endo
endp
